/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class UnicastTestRpcDist
extends ReceiverAdapter {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "UnicastTest-Group";
    private final List<Address> members = new ArrayList<Address>();
    private boolean sync = true;
    private boolean oob = true;
    private int num_threads = 25;
    private int num_msgs = 20000;
    private int msg_size = 1000;
    private int anycast_count = 2;
    private double read_percentage = 0.8;
    private static final Method[] METHODS = new Method[15];
    private static final short START = 0;
    private static final short SET_OOB = 1;
    private static final short SET_SYNC = 2;
    private static final short SET_NUM_MSGS = 3;
    private static final short SET_NUM_THREADS = 4;
    private static final short SET_MSG_SIZE = 5;
    private static final short SET_ANYCAST_COUNT = 6;
    private static final short SET_READ_PERCENTAGE = 7;
    private static final short GET = 8;
    private static final short PUT = 9;
    private static final short GET_CONFIG = 10;
    private final AtomicInteger COUNTER = new AtomicInteger(1);
    private byte[] GET_RSP = new byte[this.msg_size];
    private static final Class<?>[] unicast_protocols = new Class[]{UNICAST.class, UNICAST2.class};
    static NumberFormat f;
    long tot = 0L;
    int num_reqs = 0;

    public void init(String props, String name) throws Throwable {
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.disp = new RpcDispatcher((Channel)this.channel, null, (MembershipListener)this, this);
        this.disp.setMethodLookup(new MethodLookup(){

            @Override
            public Method findMethod(short id) {
                return METHODS[id];
            }
        });
        this.disp.setRequestMarshaller(new CustomMarshaller());
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
        if (this.members.size() < 2) {
            return;
        }
        Address coord = this.members.get(0);
        ConfigOptions config = (ConfigOptions)this.disp.callRemoteMethod(coord, new MethodCall(10, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            this.oob = config.oob;
            this.sync = config.sync;
            this.num_threads = config.num_threads;
            this.num_msgs = config.num_msgs;
            this.msg_size = config.msg_size;
            this.anycast_count = config.anycast_count;
            this.read_percentage = config.read_percentage;
            System.out.println("Fetched config from " + coord + ": " + config);
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    void stop() {
        if (this.disp != null) {
            this.disp.stop();
        }
        Util.close((Channel)this.channel);
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("** view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
    }

    public Results startTest() throws Throwable {
        System.out.println("invoking " + this.num_msgs + " RPCs of " + Util.printBytes(this.msg_size) + ", sync=" + this.sync + ", oob=" + this.oob);
        int total_gets = 0;
        int total_puts = 0;
        AtomicInteger num_msgs_sent = new AtomicInteger(0);
        Invoker[] invokers = new Invoker[this.num_threads];
        for (int i = 0; i < invokers.length; ++i) {
            invokers[i] = new Invoker(this.members, this.num_msgs, num_msgs_sent);
        }
        long start = System.currentTimeMillis();
        for (Invoker invoker : invokers) {
            invoker.start();
        }
        for (Invoker invoker : invokers) {
            invoker.join();
            total_gets += invoker.numGets();
            total_puts += invoker.numPuts();
        }
        long total_time = System.currentTimeMillis() - start;
        System.out.println("done (in " + total_time + " ms)");
        return new Results(total_gets, total_puts, total_time);
    }

    public void setOOB(boolean oob) {
        this.oob = oob;
        System.out.println("oob=" + oob);
    }

    public void setSync(boolean val) {
        this.sync = val;
        System.out.println("sync=" + this.sync);
    }

    public void setNumMessages(int num) {
        this.num_msgs = num;
        System.out.println("num_msgs = " + this.num_msgs);
    }

    public void setNumThreads(int num) {
        this.num_threads = num;
        System.out.println("num_threads = " + this.num_threads);
    }

    public void setMessageSize(int num) {
        this.msg_size = num;
        System.out.println("msg_size = " + this.msg_size);
    }

    public void setAnycastCount(int num) {
        this.anycast_count = num;
        System.out.println("anycast_count = " + this.anycast_count);
    }

    public void setReadPercentage(double val) {
        this.read_percentage = val;
        System.out.println("read_percentage = " + this.read_percentage);
    }

    public byte[] get(long key) {
        return this.GET_RSP;
    }

    public void put(long key, byte[] val) {
    }

    public ConfigOptions getConfig() {
        return new ConfigOptions(this.oob, this.sync, this.num_threads, this.num_msgs, this.msg_size, this.anycast_count, this.read_percentage);
    }

    public void eventLoop() throws Throwable {
        block19: while (true) {
            int c = Util.keyPress("[1] Send msgs [2] Print view [3] Print conns [4] Trash conn [5] Trash all conns\n[6] Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") " + "[8] Set msg size (" + Util.printBytes(this.msg_size) + ")" + " [9] Set anycast count (" + this.anycast_count + ")" + "\n[o] Toggle OOB (" + this.oob + ") [s] Toggle sync (" + this.sync + ") [r] Set read percentage (" + f.format(this.read_percentage) + ")" + "\n[q] Quit\n");
            switch (c) {
                case -1: {
                    break;
                }
                case 49: {
                    try {
                        this.startBenchmark();
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                    continue block19;
                }
                case 50: {
                    this.printView();
                    break;
                }
                case 51: {
                    this.printConnections();
                    break;
                }
                case 52: {
                    this.removeConnection();
                    break;
                }
                case 53: {
                    this.removeAllConnections();
                    break;
                }
                case 54: {
                    this.setSenderThreads();
                    break;
                }
                case 55: {
                    this.setNumMessages();
                    break;
                }
                case 56: {
                    this.setMessageSize();
                    break;
                }
                case 57: {
                    this.setAnycastCount();
                    break;
                }
                case 111: {
                    boolean new_value = !this.oob;
                    this.disp.callRemoteMethods(null, new MethodCall(1, new_value), RequestOptions.SYNC());
                    break;
                }
                case 115: {
                    boolean new_val = !this.sync;
                    this.disp.callRemoteMethods(null, new MethodCall(2, new_val), RequestOptions.SYNC());
                    break;
                }
                case 114: {
                    this.setReadPercentage();
                    break;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
                case 10: 
                case 13: {
                    break;
                }
            }
        }
    }

    private void printConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(unicast_protocols);
        if (prot instanceof UNICAST) {
            System.out.println("connections:\n" + ((UNICAST)prot).printConnections());
        } else if (prot instanceof UNICAST2) {
            System.out.println("connections:\n" + ((UNICAST2)prot).printConnections());
        }
    }

    private void removeConnection() {
        Address member = this.getReceiver();
        if (member != null) {
            Protocol prot = this.channel.getProtocolStack().findProtocol(unicast_protocols);
            if (prot instanceof UNICAST) {
                ((UNICAST)prot).removeConnection(member);
            } else if (prot instanceof UNICAST2) {
                ((UNICAST2)prot).removeConnection(member);
            }
        }
    }

    private void removeAllConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(unicast_protocols);
        if (prot instanceof UNICAST) {
            ((UNICAST)prot).removeAllConnections();
        } else if (prot instanceof UNICAST2) {
            ((UNICAST2)prot).removeAllConnections();
        }
    }

    void startBenchmark() throws Throwable {
        RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L);
        options.setFlags(Message.OOB, Message.DONT_BUNDLE, Message.NO_FC);
        RspList responses = this.disp.callRemoteMethods(null, new MethodCall(0, new Object[0]), options);
        long total_reqs = 0L;
        long total_time = 0L;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = entry.getKey();
            Rsp rsp = entry.getValue();
            Results result = (Results)rsp.getValue();
            total_reqs += result.num_gets + result.num_puts;
            total_time += result.time;
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_reqs / ((double)total_time / 1000.0);
        double throughput = total_reqs_sec * (double)this.msg_size;
        double ms_per_req = (double)total_time / (double)total_reqs;
        Protocol prot = this.channel.getProtocolStack().findProtocol(unicast_protocols);
        System.out.println("\nAverage of " + f.format(total_reqs_sec) + " requests / sec (" + Util.printBytes(throughput) + " / sec), " + f.format(ms_per_req) + " ms /request (prot=" + prot.getName() + ")");
        System.out.println("\n\n");
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        this.disp.callRemoteMethods(null, new MethodCall(4, threads), RequestOptions.SYNC());
    }

    void setNumMessages() throws Exception {
        int tmp = Util.readIntFromStdin("Number of RPCs: ");
        this.disp.callRemoteMethods(null, new MethodCall(3, tmp), RequestOptions.SYNC());
    }

    void setMessageSize() throws Exception {
        int tmp = Util.readIntFromStdin("Message size: ");
        this.disp.callRemoteMethods(null, new MethodCall(5, tmp), RequestOptions.SYNC());
    }

    void setReadPercentage() throws Exception {
        double tmp = Util.readDoubleFromStdin("Read percentage: ");
        if (tmp < 0.0 || tmp > 1.0) {
            System.err.println("read percentage must be >= 0 or <= 1.0");
            return;
        }
        this.disp.callRemoteMethods(null, new MethodCall(7, tmp), RequestOptions.SYNC());
    }

    void setAnycastCount() throws Exception {
        View view;
        int tmp = Util.readIntFromStdin("Anycast count: ");
        if (tmp > (view = this.channel.getView()).size()) {
            System.err.println("anycast count must be smaller or equal to the view size (" + view + ")\n");
            return;
        }
        this.disp.callRemoteMethods(null, new MethodCall(6, tmp), RequestOptions.SYNC());
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Address getReceiver() {
        try {
            List<Address> mbrs = this.channel.getView().getMembers();
            int index = mbrs.indexOf(this.local_addr);
            int new_index = index + 1 % mbrs.size();
            return mbrs.get(new_index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        block5: {
            String props = null;
            String name = null;
            for (int i = 0; i < args.length; ++i) {
                if ("-props".equals(args[i])) {
                    props = args[++i];
                    continue;
                }
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                UnicastTestRpcDist.help();
                return;
            }
            UnicastTestRpcDist test = null;
            try {
                test = new UnicastTestRpcDist();
                test.init(props, name);
                test.eventLoop();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block5;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("UnicastTestRpc [-props <props>] [-name name]");
    }

    static {
        try {
            UnicastTestRpcDist.METHODS[0] = UnicastTestRpcDist.class.getMethod("startTest", new Class[0]);
            UnicastTestRpcDist.METHODS[1] = UnicastTestRpcDist.class.getMethod("setOOB", Boolean.TYPE);
            UnicastTestRpcDist.METHODS[2] = UnicastTestRpcDist.class.getMethod("setSync", Boolean.TYPE);
            UnicastTestRpcDist.METHODS[3] = UnicastTestRpcDist.class.getMethod("setNumMessages", Integer.TYPE);
            UnicastTestRpcDist.METHODS[4] = UnicastTestRpcDist.class.getMethod("setNumThreads", Integer.TYPE);
            UnicastTestRpcDist.METHODS[5] = UnicastTestRpcDist.class.getMethod("setMessageSize", Integer.TYPE);
            UnicastTestRpcDist.METHODS[6] = UnicastTestRpcDist.class.getMethod("setAnycastCount", Integer.TYPE);
            UnicastTestRpcDist.METHODS[7] = UnicastTestRpcDist.class.getMethod("setReadPercentage", Double.TYPE);
            UnicastTestRpcDist.METHODS[8] = UnicastTestRpcDist.class.getMethod("get", Long.TYPE);
            UnicastTestRpcDist.METHODS[9] = UnicastTestRpcDist.class.getMethod("put", Long.TYPE, byte[].class);
            UnicastTestRpcDist.METHODS[10] = UnicastTestRpcDist.class.getMethod("getConfig", new Class[0]);
            ClassConfigurator.add((short)11000, Results.class);
            f = NumberFormat.getNumberInstance();
            f.setGroupingUsed(false);
            f.setMinimumFractionDigits(2);
            f.setMaximumFractionDigits(2);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static class CustomMarshaller
    implements RpcDispatcher.Marshaller {
        CustomMarshaller() {
        }

        @Override
        public Buffer objectToBuffer(Object obj) throws Exception {
            MethodCall call = (MethodCall)obj;
            switch (call.getId()) {
                case 0: 
                case 10: {
                    ByteBuffer buf = ByteBuffer.allocate(1);
                    buf.put((byte)call.getId());
                    return new Buffer(buf.array());
                }
                case 1: 
                case 2: {
                    return new Buffer(CustomMarshaller.booleanBuffer(call.getId(), (Boolean)call.getArgs()[0]));
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return new Buffer(CustomMarshaller.intBuffer(call.getId(), (Integer)call.getArgs()[0]));
                }
                case 8: {
                    return new Buffer(CustomMarshaller.longBuffer(call.getId(), (Long)call.getArgs()[0]));
                }
                case 9: {
                    Long long_arg = (Long)call.getArgs()[0];
                    byte[] arg2 = (byte[])call.getArgs()[1];
                    ByteBuffer buf = ByteBuffer.allocate(13 + arg2.length);
                    buf.put((byte)call.getId()).putLong(long_arg).putInt(arg2.length).put(arg2, 0, arg2.length);
                    return new Buffer(buf.array());
                }
                case 7: {
                    Double double_arg = (Double)call.getArgs()[0];
                    ByteBuffer buf = ByteBuffer.allocate(9);
                    buf.put((byte)call.getId()).putDouble(double_arg);
                    return new Buffer(buf.array());
                }
            }
            throw new IllegalStateException("method " + call.getMethod() + " not known");
        }

        @Override
        public Object objectFromBuffer(byte[] buffer, int offset, int length) throws Exception {
            ByteBuffer buf = ByteBuffer.wrap(buffer, offset, length);
            byte type = buf.get();
            switch (type) {
                case 0: 
                case 10: {
                    return new MethodCall(type, new Object[0]);
                }
                case 1: 
                case 2: {
                    return new MethodCall(type, buf.get() == 1);
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return new MethodCall(type, buf.getInt());
                }
                case 8: {
                    return new MethodCall(type, buf.getLong());
                }
                case 9: {
                    Long longarg = buf.getLong();
                    int len = buf.getInt();
                    byte[] arg2 = new byte[len];
                    buf.get(arg2, 0, arg2.length);
                    return new MethodCall(type, longarg, arg2);
                }
                case 7: {
                    return new MethodCall(type, buf.getDouble());
                }
            }
            throw new IllegalStateException("type " + type + " not known");
        }

        private static byte[] intBuffer(short type, Integer num) {
            ByteBuffer buf = ByteBuffer.allocate(5);
            buf.put((byte)type).putInt(num);
            return buf.array();
        }

        private static byte[] longBuffer(short type, Long num) {
            ByteBuffer buf = ByteBuffer.allocate(9);
            buf.put((byte)type).putLong(num);
            return buf.array();
        }

        private static byte[] booleanBuffer(short type, Boolean arg) {
            ByteBuffer buf = ByteBuffer.allocate(2);
            buf.put((byte)type).put((byte)(arg != false ? 1 : 0));
            return buf.array();
        }
    }

    public static class ConfigOptions
    implements Streamable {
        private boolean sync;
        private boolean oob;
        private int num_threads;
        private int num_msgs;
        private int msg_size;
        private int anycast_count;
        private double read_percentage;

        public ConfigOptions() {
        }

        public ConfigOptions(boolean oob, boolean sync, int num_threads, int num_msgs, int msg_size, int anycast_count, double read_percentage) {
            this.oob = oob;
            this.sync = sync;
            this.num_threads = num_threads;
            this.num_msgs = num_msgs;
            this.msg_size = msg_size;
            this.anycast_count = anycast_count;
            this.read_percentage = read_percentage;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeBoolean(this.oob);
            out.writeBoolean(this.sync);
            out.writeInt(this.num_threads);
            out.writeInt(this.num_msgs);
            out.writeInt(this.msg_size);
            out.writeInt(this.anycast_count);
            out.writeDouble(this.read_percentage);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.oob = in.readBoolean();
            this.sync = in.readBoolean();
            this.num_threads = in.readInt();
            this.num_msgs = in.readInt();
            this.msg_size = in.readInt();
            this.anycast_count = in.readInt();
            this.read_percentage = in.readDouble();
        }

        public String toString() {
            return "oob=" + this.oob + ", sync=" + this.sync + ", anycast_count=" + this.anycast_count + ", num_threads=" + this.num_threads + ", num_msgs=" + this.num_msgs + ", msg_size=" + this.msg_size + ", read percentage=" + this.read_percentage;
        }
    }

    public static class Results
    implements Streamable {
        long num_gets = 0L;
        long num_puts = 0L;
        long time = 0L;

        public Results() {
        }

        public Results(int num_gets, int num_puts, long time) {
            this.num_gets = num_gets;
            this.num_puts = num_puts;
            this.time = time;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeLong(this.num_gets);
            out.writeLong(this.num_puts);
            out.writeLong(this.time);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.num_gets = in.readLong();
            this.num_puts = in.readLong();
            this.time = in.readLong();
        }

        public String toString() {
            long total_reqs = this.num_gets + this.num_puts;
            double total_reqs_per_sec = (double)total_reqs / ((double)this.time / 1000.0);
            return f.format(total_reqs_per_sec) + " reqs/sec (" + this.num_gets + " GETs, " + this.num_puts + " PUTs total)";
        }
    }

    private class Invoker
    extends Thread {
        private final List<Address> dests = new ArrayList<Address>();
        private final int num_msgs_to_send;
        private final AtomicInteger num_msgs_sent;
        private int num_gets = 0;
        private int num_puts = 0;

        public Invoker(Collection<Address> dests, int num_msgs_to_send, AtomicInteger num_msgs_sent) {
            this.num_msgs_sent = num_msgs_sent;
            this.dests.addAll(dests);
            this.num_msgs_to_send = num_msgs_to_send;
            this.setName("Invoker-" + UnicastTestRpcDist.this.COUNTER.getAndIncrement());
        }

        public int numGets() {
            return this.num_gets;
        }

        public int numPuts() {
            return this.num_puts;
        }

        @Override
        public void run() {
            long i;
            byte[] buf = new byte[UnicastTestRpcDist.this.msg_size];
            Object[] put_args = new Object[]{0, buf};
            Object[] get_args = new Object[]{0};
            MethodCall get_call = new MethodCall(8, get_args);
            MethodCall put_call = new MethodCall(9, put_args);
            RequestOptions get_options = new RequestOptions(ResponseMode.GET_ALL, 20000L, false, null);
            RequestOptions put_options = new RequestOptions(UnicastTestRpcDist.this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, 20000L, true, null);
            if (UnicastTestRpcDist.this.oob) {
                get_options.setFlags(Message.OOB);
                put_options.setFlags(Message.OOB);
            }
            if (UnicastTestRpcDist.this.sync) {
                get_options.setFlags(Message.DONT_BUNDLE, Message.NO_FC);
                put_options.setFlags(Message.DONT_BUNDLE, Message.NO_FC);
            }
            while ((i = (long)this.num_msgs_sent.getAndIncrement()) < (long)this.num_msgs_to_send) {
                boolean get = Util.tossWeightedCoin(UnicastTestRpcDist.this.read_percentage);
                try {
                    if (get) {
                        Address target = this.pickTarget();
                        get_args[0] = i;
                        UnicastTestRpcDist.this.disp.callRemoteMethod(target, get_call, get_options);
                        ++this.num_gets;
                        continue;
                    }
                    Collection<Address> targets = this.pickAnycastTargets();
                    put_args[0] = i;
                    UnicastTestRpcDist.this.disp.callRemoteMethods(targets, put_call, put_options);
                    ++this.num_puts;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        private Address pickTarget() {
            int index = this.dests.indexOf(UnicastTestRpcDist.this.local_addr);
            int new_index = (index + 1) % this.dests.size();
            return this.dests.get(new_index);
        }

        private Collection<Address> pickAnycastTargets() {
            ArrayList<Address> anycast_targets = new ArrayList<Address>(UnicastTestRpcDist.this.anycast_count);
            int index = this.dests.indexOf(UnicastTestRpcDist.this.local_addr);
            for (int i = index + 1; i < index + 1 + UnicastTestRpcDist.this.anycast_count; ++i) {
                int new_index = i % this.dests.size();
                Address tmp = this.dests.get(new_index);
                if (anycast_targets.contains(tmp)) continue;
                anycast_targets.add(tmp);
            }
            return anycast_targets;
        }
    }
}

