/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.hibernate.ejb.criteria.CollectionJoinImplementor;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.FromImplementor;
import org.hibernate.ejb.criteria.JoinImplementor;
import org.hibernate.ejb.criteria.ListJoinImplementor;
import org.hibernate.ejb.criteria.MapJoinImplementor;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryStructure;
import org.hibernate.ejb.criteria.SetJoinImplementor;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.path.RootImpl;

public class CriteriaSubqueryImpl<T>
extends ExpressionImpl<T>
implements Subquery<T>,
Serializable {
    private final AbstractQuery<?> parent;
    private final QueryStructure<T> queryStructure;

    public CriteriaSubqueryImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, AbstractQuery<?> parent) {
        super(criteriaBuilder, javaType);
        this.parent = parent;
        this.queryStructure = new QueryStructure(this, criteriaBuilder);
    }

    public AbstractQuery<?> getParent() {
        return this.parent;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (ParameterExpression<?> param : this.queryStructure.getParameters()) {
            registry.registerParameter(param);
        }
    }

    public Class<T> getResultType() {
        return this.getJavaType();
    }

    public Set<Root<?>> getRoots() {
        return this.queryStructure.getRoots();
    }

    public <X> Root<X> from(EntityType<X> entityType) {
        return this.queryStructure.from(entityType);
    }

    public <X> Root<X> from(Class<X> entityClass) {
        return this.queryStructure.from(entityClass);
    }

    public Subquery<T> distinct(boolean applyDistinction) {
        this.queryStructure.setDistinct(applyDistinction);
        return this;
    }

    public boolean isDistinct() {
        return this.queryStructure.isDistinct();
    }

    public Expression<T> getSelection() {
        return (Expression)this.queryStructure.getSelection();
    }

    public Subquery<T> select(Expression<T> expression) {
        this.queryStructure.setSelection((Selection<T>)expression);
        return this;
    }

    public Predicate getRestriction() {
        return this.queryStructure.getRestriction();
    }

    public Subquery<T> where(Expression<Boolean> expression) {
        this.queryStructure.setRestriction(this.criteriaBuilder().wrap(expression));
        return this;
    }

    public Subquery<T> where(Predicate ... predicates) {
        this.queryStructure.setRestriction(this.criteriaBuilder().and(predicates));
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this.queryStructure.getGroupings();
    }

    public Subquery<T> groupBy(Expression<?> ... groupings) {
        this.queryStructure.setGroupings(groupings);
        return this;
    }

    public Subquery<T> groupBy(List<Expression<?>> groupings) {
        this.queryStructure.setGroupings(groupings);
        return this;
    }

    public Predicate getGroupRestriction() {
        return this.queryStructure.getHaving();
    }

    public Subquery<T> having(Expression<Boolean> expression) {
        this.queryStructure.setHaving(this.criteriaBuilder().wrap(expression));
        return this;
    }

    public Subquery<T> having(Predicate ... predicates) {
        this.queryStructure.setHaving(this.criteriaBuilder().and(predicates));
        return this;
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        return this.queryStructure.collectCorrelatedJoins();
    }

    public <Y> Root<Y> correlate(Root<Y> source) {
        FromImplementor correlation = ((RootImpl)source).correlateTo(this);
        this.queryStructure.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> Join<X, Y> correlate(Join<X, Y> source) {
        JoinImplementor correlation = ((JoinImplementor)source).correlateTo(this);
        this.queryStructure.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> CollectionJoin<X, Y> correlate(CollectionJoin<X, Y> source) {
        CollectionJoinImplementor correlation = ((CollectionJoinImplementor)source).correlateTo(this);
        this.queryStructure.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> SetJoin<X, Y> correlate(SetJoin<X, Y> source) {
        SetJoinImplementor correlation = ((SetJoinImplementor)source).correlateTo(this);
        this.queryStructure.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> ListJoin<X, Y> correlate(ListJoin<X, Y> source) {
        ListJoinImplementor correlation = ((ListJoinImplementor)source).correlateTo(this);
        this.queryStructure.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, K, V> MapJoin<X, K, V> correlate(MapJoin<X, K, V> source) {
        MapJoinImplementor correlation = ((MapJoinImplementor)source).correlateTo(this);
        this.queryStructure.addCorrelationRoot(correlation);
        return correlation;
    }

    public <U> Subquery<U> subquery(Class<U> subqueryType) {
        return this.queryStructure.subquery(subqueryType);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        StringBuilder subqueryBuffer = new StringBuilder("(");
        this.queryStructure.render(subqueryBuffer, renderingContext);
        subqueryBuffer.append(')');
        return subqueryBuffer.toString();
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        throw new IllegalStateException("Subquery cannot occur in select clause");
    }
}

