/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.credential;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.picketlink.idm.impl.credential.AbstractCredentialEncoder;

public class HashingEncoder
extends AbstractCredentialEncoder {
    public static final String OPTION_CREDENTIAL_ENCODER_HASH_ALGORITHM = "credentialEncoder.hashAlgorithm";
    private static final String OPTION_DEFAULT_HASH_ALGORITHM = "MD5";
    private String hashAlgorithm;

    @Override
    protected void afterInitialize() {
        this.hashAlgorithm = this.getEncoderProperty(OPTION_CREDENTIAL_ENCODER_HASH_ALGORITHM);
        if (this.hashAlgorithm == null) {
            this.hashAlgorithm = OPTION_DEFAULT_HASH_ALGORITHM;
        }
        this.log.info("Algorithm " + this.hashAlgorithm + " will be used for password hashing");
    }

    @Override
    public String encodeCredential(String username, String plainCredential) {
        return this.toHexString(this.hashEncode(plainCredential));
    }

    private byte[] hashEncode(String text) {
        if (text == null) {
            throw new NullPointerException("null text");
        }
        try {
            MessageDigest md = this.getMessageDigest();
            md.update(text.getBytes());
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot find hash algorithm: " + this.hashAlgorithm, e);
        }
    }

    protected MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.hashAlgorithm);
    }

    protected String toHexString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        StringBuffer hex = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            hex.append(Character.forDigit((bytes[i] & 0xF0) >> 4, 16));
            hex.append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return hex.toString();
    }
}

