/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.infinispan.util.Base64;

class PBEEncoder {
    private final SecretKey cipherKey;
    private final String cipherAlgorithm;
    private final PBEParameterSpec cipherSpec;

    PBEEncoder(char[] keyStorePassword, String cipherAlgorithm, byte[] salt, int iterationCount) {
        this.cipherAlgorithm = cipherAlgorithm;
        try {
            this.cipherSpec = new PBEParameterSpec(salt, iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(keyStorePassword);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(cipherAlgorithm);
            this.cipherKey = factory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String encode64(String secret) throws Exception {
        byte[] secretBytes = secret.getBytes("UTF-8");
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        cipher.init(1, (Key)this.cipherKey, this.cipherSpec);
        byte[] encoding = cipher.doFinal(secretBytes);
        return Base64.encodeBytes((byte[])encoding);
    }

    public String decode64(String secret) throws Exception {
        byte[] encoding = Base64.decode((String)secret);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        cipher.init(2, (Key)this.cipherKey, this.cipherSpec);
        byte[] decode = cipher.doFinal(encoding);
        return new String(decode, "UTF-8");
    }
}

