/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOTools {
    private static final Logger log = Logger.getLogger(IOTools.class.getName());
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_PARAMETER_TYPES = new Class[0];

    public static void safeClose(Object closable) {
        if (closable != null) {
            try {
                Method m = closable.getClass().getMethod("close", EMPTY_PARAMETER_TYPES);
                if (Modifier.isStatic(m.getModifiers())) {
                    log.log(Level.WARNING, "close() method on closable object is static");
                    return;
                }
                m.invoke(closable, EMPTY_ARGS);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.WARNING, "The closable object does not have a close() method", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.WARNING, "Cannot access close() method on closable object", e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof RuntimeException) {
                    log.log(Level.SEVERE, "The close() method threw a runtime exception", t);
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    log.log(Level.SEVERE, "The close() method threw an error", t);
                    throw (Error)t;
                }
                if (t instanceof Exception) {
                    log.log(Level.SEVERE, "The close() method threw an exception", t);
                }
                log.log(Level.SEVERE, "The close() method threw an unexpected throwable", t);
            }
        }
    }

    public static void safeClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error while closing outstream", e);
            }
        }
    }

    public static void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error while closing inputstream", e);
            }
        }
    }

    public static void safeClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error while closing reader", e);
            }
        }
    }

    public static void safeClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error while closing writer", e);
            }
        }
    }

    public static BufferedInputStream safeBufferedWrapper(InputStream in) {
        if (in != null) {
            if (in instanceof BufferedInputStream) {
                return (BufferedInputStream)in;
            }
            return new BufferedInputStream(in);
        }
        return null;
    }

    public static BufferedOutputStream safeBufferedWrapper(OutputStream out) {
        if (out != null) {
            if (out instanceof BufferedOutputStream) {
                return (BufferedOutputStream)out;
            }
            return new BufferedOutputStream(out);
        }
        return null;
    }
}

