/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.query;

import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.query.RoleQuery;
import org.picketlink.idm.api.query.RoleQueryBuilder;
import org.picketlink.idm.api.query.UnsupportedQueryCriterium;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleRoleType;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.api.query.AbstractQueryBuilder;
import org.picketlink.idm.impl.api.query.RoleQueryImpl;

public class RoleQueryBuilderImpl
extends AbstractQueryBuilder
implements RoleQueryBuilder {
    private User user;
    private Group group;
    private RoleType roleType;

    @Override
    public RoleQuery createQuery() {
        return new RoleQueryImpl(this.searchCriteria, this.user, this.group, this.roleType);
    }

    @Override
    public RoleQueryBuilder reset() {
        this.searchCriteria = new IdentitySearchCriteriaImpl();
        this.user = null;
        this.group = null;
        this.roleType = null;
        return this;
    }

    @Override
    public RoleQueryBuilder setUser(User user) {
        this.checkNotNullArgument(user, "User");
        this.user = user;
        return this;
    }

    @Override
    public RoleQueryBuilder setUser(String id) {
        this.checkNotNullArgument(id, "User id");
        this.user = new SimpleUser(id);
        return this;
    }

    @Override
    public RoleQueryBuilder setGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.group = group;
        return this;
    }

    @Override
    public RoleQueryBuilder setGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.group = new SimpleGroup(new GroupKey(id));
        return this;
    }

    @Override
    public RoleQueryBuilder setRoleType(RoleType roleType) {
        this.checkNotNullArgument(roleType, "RoleType");
        this.roleType = roleType;
        return this;
    }

    @Override
    public RoleQueryBuilder setRoleType(String roleTypeName) {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.roleType = new SimpleRoleType(roleTypeName);
        return this;
    }

    @Override
    public RoleQueryBuilder setIdentityType(IdentityType identityType) {
        this.checkNotNullArgument(identityType, "IdentityType");
        if (identityType instanceof User) {
            this.user = (User)identityType;
        } else {
            this.group = (Group)identityType;
        }
        return this;
    }

    @Override
    public RoleQueryBuilder setIdentityTypeKey(String id) {
        this.checkNotNullArgument(id, "IdentityType id");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.setIdentityType(identityType);
    }

    @Override
    public RoleQueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.sort(order);
    }

    @Override
    public RoleQueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.sortAttributeName(name);
    }

    @Override
    public RoleQueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.page(firstResult, maxResults);
    }

    @Override
    public RoleQueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.attributeValuesFilter(attributeName, attributeValue);
    }
}

