/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.statetransfer.StateTransferManagerImpl;

@DefaultFactoryFor(classes={StateTransferManager.class, StateConsumer.class, StateProvider.class})
public class StateTransferComponentFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (!this.configuration.clustering().cacheMode().isClustered()) {
            return null;
        }
        if (componentType.equals(StateTransferManager.class)) {
            return componentType.cast(new StateTransferManagerImpl());
        }
        if (componentType.equals(StateProvider.class)) {
            return componentType.cast(new StateProviderImpl());
        }
        if (componentType.equals(StateConsumer.class)) {
            return componentType.cast(new StateConsumerImpl());
        }
        throw new ConfigurationException("Don't know how to create a " + componentType.getName());
    }
}

