/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OptimisticNodeInterceptor
extends OptimisticInterceptor {
    private NodeFactory nodeFactory;
    private Notifier notifier;
    private DataContainer dataContainer;
    private long lockAcquisitionTimeout;

    @Inject
    protected void injectDependencies(Notifier notifier, NodeFactory nodeFactory, DataContainer dataContainer) {
        this.notifier = notifier;
        this.nodeFactory = nodeFactory;
        this.dataContainer = dataContainer;
    }

    @Start
    void init() {
        this.lockAcquisitionTimeout = this.configuration.getLockAcquisitionTimeout();
    }

    public OptimisticNodeInterceptor() {
        this.log = LogFactory.getLog(this.getClass());
        this.trace = this.log.isTraceEnabled();
    }

    @Override
    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, false, true);
        if (workspaceNode != null) {
            this.setVersioning(ctx, workspace, workspaceNode);
        }
        Boolean result = this.removeNode(workspace, workspaceNode, true, ctx);
        this.addToModificationList(command, ctx);
        return result;
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, true, true);
        if (workspaceNode != null) {
            this.setVersioning(ctx, workspace, workspaceNode);
        } else if (ctx.getOptionOverrides() == null || !ctx.getOptionOverrides().isFailSilently()) {
            throw new CacheException("Unable to set node version for " + command.getFqn() + ", node is null.");
        }
        Object result = this.putDataKeyValueAndNotify(command.getKey(), command.getValue(), workspace, workspaceNode, ctx);
        this.addToModificationList(command, ctx);
        return result;
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, true, true);
        if (workspaceNode != null) {
            this.setVersioning(ctx, workspace, workspaceNode);
        } else if (ctx.getOptionOverrides() == null || !ctx.getOptionOverrides().isFailSilently()) {
            throw new CacheException("Unable to set node version for " + command.getFqn() + ", node is null.");
        }
        this.putDataMapAndNotify(command.getData(), workspace, workspaceNode, ctx);
        this.addToModificationList(command, ctx);
        return null;
    }

    @Override
    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, true, true);
        if (ctx.isOriginLocal() && ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
            throw new CacheException("Setting a data version while performing a move() is not supported!!");
        }
        if (workspaceNode != null) {
            this.setVersioning(ctx, workspace, workspaceNode);
        }
        this.moveNodeAndNotify(command.getTo(), workspaceNode, workspace, ctx);
        this.addToModificationList(command, ctx);
        return null;
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, true, true);
        if (workspaceNode != null) {
            this.setVersioning(ctx, workspace, workspaceNode);
        }
        Object result = this.removeKeyAndNotify(command.getKey(), workspace, workspaceNode, ctx);
        this.addToModificationList(command, ctx);
        return result;
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, true, true);
        if (workspaceNode != null) {
            this.setVersioning(ctx, workspace, workspaceNode);
        }
        this.removeDataAndNotify(workspace, workspaceNode, ctx);
        this.addToModificationList(command, ctx);
        return null;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object result;
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, false, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.debug((Object)("Unable to find node " + command.getFqn() + " in workspace."));
            }
            result = null;
        } else {
            this.notifier.notifyNodeVisited(command.getFqn(), true, ctx);
            Object val = workspaceNode.get(command.getKey());
            workspace.addNode(workspaceNode);
            this.notifier.notifyNodeVisited(command.getFqn(), false, ctx);
            result = val;
        }
        return result;
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        Set result;
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        Fqn fqn = command.getFqn();
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, fqn, workspace, false, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.trace((Object)("unable to find node " + fqn + " in workspace."));
            }
            result = null;
        } else {
            this.notifier.notifyNodeVisited(fqn, true, ctx);
            Set keySet = workspaceNode.getKeys();
            workspace.addNode(workspaceNode);
            this.notifier.notifyNodeVisited(fqn, false, ctx);
            result = keySet;
        }
        return result;
    }

    @Override
    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        Map result;
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, false, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.trace((Object)("unable to find node " + command.getFqn() + " in workspace."));
            }
            result = null;
        } else {
            this.notifier.notifyNodeVisited(command.getFqn(), true, ctx);
            Map data = workspaceNode.getData();
            workspace.addNode(workspaceNode);
            this.notifier.notifyNodeVisited(command.getFqn(), false, ctx);
            result = data;
        }
        return result;
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        Set<Object> result;
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, false, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.trace((Object)("Unable to find node " + command.getFqn() + " in workspace."));
            }
            result = null;
        } else {
            this.notifier.notifyNodeVisited(command.getFqn(), true, ctx);
            Set<Object> nameSet = workspaceNode.getChildrenNames();
            workspace.addNode(workspaceNode);
            this.notifier.notifyNodeVisited(command.getFqn(), false, ctx);
            result = nameSet;
        }
        return result;
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        NodeSPI result;
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        WorkspaceNode workspaceNode = this.fetchWorkspaceNode(ctx, command.getFqn(), workspace, false, false);
        if (workspaceNode == null) {
            if (this.trace) {
                this.log.trace((Object)("Unable to find node " + command.getFqn() + " in workspace."));
            }
            result = null;
        } else if (workspaceNode.isRemoved()) {
            if (this.trace) {
                this.log.trace((Object)("Attempted to retrieve node " + command.getFqn() + " but it has been deleted!"));
            }
            result = null;
        } else {
            this.notifier.notifyNodeVisited(command.getFqn(), true, ctx);
            workspace.addNode(workspaceNode);
            this.notifier.notifyNodeVisited(command.getFqn(), false, ctx);
            result = workspaceNode.getNode();
        }
        return result;
    }

    private void setVersioning(InvocationContext ctx, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
            workspace.setVersioningImplicit(false);
            DataVersion version = ctx.getOptionOverrides().getDataVersion();
            workspaceNode.setVersion(version);
            if (this.trace) {
                this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to explicit"));
            }
            workspaceNode.setVersioningImplicit(false);
        } else {
            if (this.trace) {
                this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to implicit"));
            }
            workspaceNode.setVersioningImplicit(true);
        }
    }

    private void addToModificationList(WriteCommand command, InvocationContext ctx) {
        ctx.getTransactionContext().addModification(command);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding command " + command + " to modification list"));
        }
    }

    private void moveNodeAndNotify(Fqn parentFqn, WorkspaceNode node, TransactionWorkspace ws, InvocationContext ctx) {
        Fqn nodeFqn = node.getFqn();
        if (nodeFqn.isRoot()) {
            this.log.warn((Object)"Attempting to move the root node.  Not taking any action, treating this as a no-op.");
            return;
        }
        WorkspaceNode oldParent = this.fetchWorkspaceNode(ctx, nodeFqn.getParent(), ws, false, true);
        if (oldParent == null) {
            throw new NodeNotExistsException("Node " + nodeFqn.getParent() + " does not exist!");
        }
        if (parentFqn.equals(oldParent.getFqn())) {
            this.log.warn((Object)"Attempting to move a node in same place.  Not taking any action, treating this as a no-op.");
            return;
        }
        WorkspaceNode parent = this.fetchWorkspaceNode(ctx, parentFqn, ws, false, true);
        if (parent == null) {
            throw new NodeNotExistsException("Node " + parentFqn + " does not exist!");
        }
        Object nodeName = nodeFqn.getLastElement();
        oldParent.removeChild(nodeName);
        Fqn<Object> nodeNewFqn = Fqn.fromRelativeElements(parent.getFqn(), nodeFqn.getLastElement());
        this.notifier.notifyNodeMoved(nodeFqn, nodeNewFqn, true, ctx);
        this.recursiveMoveNode(ctx, node, parent.getFqn(), ws);
        this.removeNode(ws, node, false, ctx);
        this.notifier.notifyNodeMoved(nodeFqn, nodeNewFqn, false, ctx);
    }

    private void recursiveMoveNode(InvocationContext ctx, WorkspaceNode node, Fqn newBase, TransactionWorkspace ws) {
        Fqn<Object> newFqn = Fqn.fromRelativeElements(newBase, node.getFqn().getLastElement());
        WorkspaceNode movedNode = this.fetchWorkspaceNode(ctx, newFqn, ws, true, true);
        movedNode.putAll(node.getData());
        for (Object n : node.getChildrenNames()) {
            WorkspaceNode child = this.fetchWorkspaceNode(ctx, Fqn.fromRelativeElements(node.getFqn(), n), ws, false, true);
            if (child == null) continue;
            this.recursiveMoveNode(ctx, child, newFqn, ws);
        }
    }

    private void putDataMapAndNotify(Map<Object, Object> data, TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            throw new NodeNotExistsException("optimisticCreateIfNotExistsInterceptor should have created this node!");
        }
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.PUT_MAP, workspaceNode.getData(), ctx);
        workspaceNode.putAll(data);
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.PUT_MAP, workspaceNode.getData(), ctx);
    }

    private Object putDataKeyValueAndNotify(Object key, Object value, TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            throw new NodeNotExistsException("optimisticCreateIfNotExistsInterceptor should have created this node!");
        }
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.PUT_DATA, workspaceNode.getData(), ctx);
        }
        Object old = workspaceNode.put(key, value);
        workspace.addNode(workspaceNode);
        if (this.notifier.shouldNotifyOnNodeModified()) {
            Map<Object, Object> addedData = Collections.singletonMap(key, value);
            this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.PUT_DATA, addedData, ctx);
        }
        return old;
    }

    private boolean removeNode(TransactionWorkspace workspace, WorkspaceNode workspaceNode, boolean notify, InvocationContext ctx) throws CacheException {
        if (workspaceNode == null) {
            return false;
        }
        Fqn parentFqn = workspaceNode.getFqn().getParent();
        WorkspaceNode parentNode = this.fetchWorkspaceNode(ctx, parentFqn, workspace, false, true);
        if (parentNode == null) {
            throw new NodeNotExistsException("Unable to find parent node with fqn " + parentFqn);
        }
        if (notify) {
            this.notifier.notifyNodeRemoved(workspaceNode.getFqn(), true, workspaceNode.getData(), ctx);
        }
        Fqn nodeFqn = workspaceNode.getFqn();
        parentNode.removeChild(nodeFqn.getLastElement());
        SortedMap tailMap = workspace.getNodesAfter(workspaceNode.getFqn());
        for (WorkspaceNode toDelete : tailMap.values()) {
            if (!toDelete.getFqn().isChildOrEquals(nodeFqn)) break;
            if (this.trace) {
                this.log.trace((Object)("marking node " + toDelete.getFqn() + " as deleted"));
            }
            toDelete.setRemoved(true);
        }
        if (notify) {
            this.notifier.notifyNodeRemoved(workspaceNode.getFqn(), false, null, ctx);
        }
        return workspaceNode.getNode().isValid();
    }

    private Object removeKeyAndNotify(Object removeKey, TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            return null;
        }
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.REMOVE_DATA, workspaceNode.getData(), ctx);
        }
        Object old = workspaceNode.remove(removeKey);
        workspace.addNode(workspaceNode);
        if (this.notifier.shouldNotifyOnNodeModified()) {
            Map removedData = Collections.singletonMap(removeKey, old);
            this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.REMOVE_DATA, removedData, ctx);
        }
        return old;
    }

    private void removeDataAndNotify(TransactionWorkspace workspace, WorkspaceNode workspaceNode, InvocationContext ctx) {
        if (workspaceNode == null) {
            return;
        }
        HashMap data = new HashMap(workspaceNode.getData());
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), true, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
        workspaceNode.clearData();
        workspace.addNode(workspaceNode);
        this.notifier.notifyNodeModified(workspaceNode.getFqn(), false, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
    }

    private WorkspaceNode fetchWorkspaceNode(InvocationContext ctx, Fqn fqn, TransactionWorkspace workspace, boolean undeleteIfNecessary, boolean includeInvalidNodes) {
        WorkspaceNode workspaceNode = workspace.getNode(fqn);
        if (workspaceNode == null) {
            NodeSPI node = this.dataContainer.peek(fqn, true, includeInvalidNodes);
            if (node == null) {
                return null;
            }
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            workspaceNode = this.lockAndCreateWorkspaceNode(this.nodeFactory, node, workspace, gtx, this.lockAcquisitionTimeout);
            workspace.addNode(workspaceNode);
        }
        if (workspaceNode.isRemoved()) {
            if (this.trace) {
                this.log.trace((Object)("Node " + fqn + " has been deleted in the workspace."));
            }
            if (undeleteIfNecessary) {
                this.undeleteWorkspaceNode(workspaceNode, this.fetchWorkspaceNode(ctx, fqn.getParent(), workspace, undeleteIfNecessary, includeInvalidNodes));
            } else if (!includeInvalidNodes) {
                workspaceNode = null;
            }
        }
        if (workspaceNode != null && !(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
            workspaceNode.setVersioningImplicit(false);
        }
        if (workspaceNode != null && !fqn.isRoot()) {
            this.fetchWorkspaceNode(ctx, fqn.getParent(), workspace, false, includeInvalidNodes);
        }
        return workspaceNode;
    }
}

