/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.xml.bind.JAXBException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPRedirectFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SignatureUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPRedirectSignatureFormAuthenticator
extends SPRedirectFormAuthenticator {
    private static Logger log = Logger.getLogger(SPRedirectSignatureFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    private TrustKeyManager keyManager;

    public void start() throws LifecycleException {
        super.start();
        Context context = (Context)this.getContainer();
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null) {
            throw new LifecycleException("KeyProvider is null for context=" + context.getName());
        }
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            this.keyManager.setAuthProperties(keyProvider.getAuth());
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        if (this.trace) {
            log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
        try {
            this.populateChainConfig();
            super.initializeHandlerChain();
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        PublicKey validatingKey;
        boolean result = super.validate(request);
        if (!result) {
            return result;
        }
        String queryString = request.getQueryString();
        byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL((String)queryString);
        if (sigValue == null) {
            return false;
        }
        String reqFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"SAMLResponse");
        String relayStateFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"RelayState");
        String sigAlgFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"SigAlg");
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLResponse=").append(reqFromURL);
        if (StringUtil.isNotNull((String)relayStateFromURL)) {
            sb.append("&RelayState=").append(relayStateFromURL);
        }
        sb.append("&SigAlg=").append(sigAlgFromURL);
        try {
            validatingKey = this.keyManager.getValidatingKey(request.getRemoteAddr());
        }
        catch (TrustKeyConfigurationException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        catch (TrustKeyProcessingException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        boolean isValid = SignatureUtil.validate((byte[])sb.toString().getBytes("UTF-8"), (byte[])sigValue, (PublicKey)validatingKey);
        return isValid;
    }

    protected String getDestination(String urlEncodedRequest, String urlEncodedRelayState, boolean sendRequest) {
        try {
            PrivateKey signingKey = this.keyManager.getSigningKey();
            StringBuffer sb = new StringBuffer();
            String url = RedirectBindingSignatureUtil.getSAMLRequestURLWithSignature((String)urlEncodedRequest, (String)urlEncodedRelayState, (PrivateKey)signingKey);
            sb.append("?").append(url);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initializeSAMLProcessor(ServiceProviderBaseProcessor processor) {
        super.initializeSAMLProcessor(processor);
        processor.setTrustKeyManager(this.keyManager);
    }

    protected ResponseType decryptAssertion(ResponseType responseType) throws IOException, GeneralSecurityException, ConfigurationException, ParsingException {
        try {
            SAML2Response saml2Response = new SAML2Response();
            PrivateKey privateKey = this.keyManager.getSigningKey();
            EncryptedElementType myEET = (EncryptedElementType)responseType.getAssertionOrEncryptedAssertion().get(0);
            Document eetDoc = saml2Response.convert(myEET);
            Element decryptedDocumentElement = XMLEncryptionUtil.decryptElementInDocument((Document)eetDoc, (PrivateKey)privateKey);
            return saml2Response.getResponseType(DocumentUtil.getNodeAsStream((Node)decryptedDocumentElement));
        }
        catch (JAXBException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
    }

    protected void populateChainConfig() throws ConfigurationException, ProcessingException {
        super.populateChainConfig();
        if (this.keyManager != null) {
            if (this.trace) {
                log.trace((Object)"Adding Keypair to the chain config");
            }
            this.chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
        }
    }
}

