/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.bindings.util.ValveUtil;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.ServerDetector;
import org.w3c.dom.Document;

public class SPPostFormAuthenticator
extends BaseFormAuthenticator {
    private static Logger log = Logger.getLogger(SPPostFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    private boolean jbossEnv = false;
    private String logOutPage = "/logout.jsp";
    protected boolean supportSignatures = false;
    protected TrustKeyManager keyManager;

    public SPPostFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        SPUtil spUtil = new SPUtil();
        String gloStr = request.getParameter("GLO");
        boolean logOutRequest = StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
        String samlRequest = request.getParameter("SAMLRequest");
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        if (!(principal == null || logOutRequest || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
            return true;
        }
        Session session = request.getSessionInternal(true);
        String relayState = request.getParameter("RelayState");
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
            SAML2HandlerResponse saml2HandlerResponse = null;
            try {
                ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(true, this.serviceURL);
                saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
                saml2HandlerResponse.setDestination(this.identityURL);
            }
            catch (ProcessingException pe) {
                log.error((Object)"Processing Exception:", (Throwable)pe);
                throw new RuntimeException(pe);
            }
            catch (ParsingException pe) {
                log.error((Object)"Parsing Exception:", (Throwable)pe);
                throw new RuntimeException(pe);
            }
            catch (ConfigurationException pe) {
                log.error((Object)"Config Exception:", (Throwable)pe);
                throw new RuntimeException(pe);
            }
            willSendRequest = saml2HandlerResponse.getSendRequest();
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            if (destination != null && samlResponseDocument != null) {
                try {
                    this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest);
                    return false;
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)"Exception:", (Throwable)e);
                    }
                    throw new IOException("Server Error");
                }
            }
        }
        if (StringUtil.isNotNull((String)samlResponse)) {
            boolean isValid = false;
            try {
                isValid = this.validate(request);
            }
            catch (Exception e) {
                log.error((Object)"Exception:", (Throwable)e);
                throw new IOException();
            }
            if (!isValid) {
                throw new IOException("Validity check failed");
            }
            try {
                ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(true, this.serviceURL);
                SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
                Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
                relayState = saml2HandlerResponse.getRelayState();
                String destination = saml2HandlerResponse.getDestination();
                willSendRequest = saml2HandlerResponse.getSendRequest();
                if (destination == null || samlResponseDocument == null) {
                    boolean sessionValidity = session.isValid();
                    if (!sessionValidity) {
                        RequestDispatcher dispatch = this.context.getServletContext().getRequestDispatcher(this.logOutPage);
                        if (dispatch == null) {
                            log.error((Object)("Cannot dispatch to the logout page: no request dispatcher:" + this.logOutPage));
                        } else {
                            dispatch.forward((ServletRequest)request, (ServletResponse)response);
                        }
                        return false;
                    }
                    List roles = saml2HandlerResponse.getRoles();
                    if (principal == null) {
                        principal = (Principal)session.getSession().getAttribute("jboss_identity.principal");
                    }
                    String username = principal.getName();
                    String password = "EMPTY_STR";
                    if (new ServerDetector().isJboss() || this.jbossEnv) {
                        ServiceProviderSAMLContext.push(username, roles);
                        principal = this.context.getRealm().authenticate(username, password);
                        ServiceProviderSAMLContext.clear();
                    } else {
                        principal = spUtil.createGenericPrincipal(request, principal.getName(), roles);
                    }
                    session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
                    session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                    request.setUserPrincipal(principal);
                    this.register(request, response, principal, "FORM", username, password);
                    return true;
                }
                this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest);
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)"Server Exception:", (Throwable)e);
                }
                throw new IOException("Server Exception");
            }
        }
        if (StringUtil.isNotNull((String)samlRequest)) {
            try {
                ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(true, this.serviceURL);
                requestProcessor.setTrustKeyManager(this.keyManager);
                requestProcessor.setSupportSignatures(this.supportSignatures);
                boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
                if (result) {
                    return result;
                }
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)"Server Exception:", (Throwable)e);
                }
                throw new IOException("Server Exception");
            }
        }
        return super.authenticate(request, response, loginConfig);
    }

    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws ProcessingException, ConfigurationException, IOException {
        String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
        samlMessage = PostBindingUtil.base64Encode((String)samlMessage);
        PostBindingUtil.sendPost((DestinationInfoHolder)new DestinationInfoHolder(destination, samlMessage, relayState), (HttpServletResponse)response, (boolean)willSendRequest);
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String domainsTrusted;
            String issuerDomain = ValveUtil.getDomain(issuer);
            TrustType idpTrust = this.spConfiguration.getTrust();
            if (idpTrust != null && (domainsTrusted = idpTrust.getDomains()).indexOf(issuerDomain) < 0) {
                throw new IssuerNotTrustedException(issuer);
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected ResponseType decryptAssertion(ResponseType responseType) {
        throw new RuntimeException("This authenticator does not handle encryption");
    }

    protected boolean verifySignature(SAMLDocumentHolder samlDocumentHolder) throws IssuerNotTrustedException {
        return true;
    }
}

