/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.idp;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.bindings.tomcat.idp.IDPRedirectValve;
import org.picketlink.identity.federation.core.config.EncryptionType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IDPRedirectWithSignatureValve
extends IDPRedirectValve {
    private static Logger log = Logger.getLogger(IDPRedirectWithSignatureValve.class);
    private boolean trace = log.isTraceEnabled();
    private boolean ignoreSignature = false;
    private TrustKeyManager keyManager;

    public void setIgnoreSignature(String val) {
        if (StringUtil.isNotNull((String)val)) {
            this.ignoreSignature = Boolean.valueOf(val);
        }
    }

    public void start() throws LifecycleException {
        super.start();
        KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
        try {
            this.keyManager = CoreConfigUtil.getTrustKeyManager((KeyProviderType)keyProvider);
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            String canonicalizationMethod = this.idpConfiguration.getCanonicalizationMethod();
            log.info((Object)("IDPRedirectWithSignatureValve:: Setting the CanonicalizationMethod on XMLSignatureUtil::" + canonicalizationMethod));
            XMLSignatureUtil.setCanonicalizationMethodType((String)canonicalizationMethod);
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        if (this.trace) {
            log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        PublicKey validatingKey;
        boolean result = super.validate(request);
        if (!result) {
            return result;
        }
        if (this.ignoreSignature) {
            if (this.trace) {
                log.trace((Object)"Since signature is to be ignored, validation returns");
            }
            return true;
        }
        String queryString = request.getQueryString();
        byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL((String)queryString);
        if (sigValue == null) {
            return false;
        }
        try {
            validatingKey = this.keyManager.getValidatingKey(request.getRemoteAddr());
        }
        catch (TrustKeyConfigurationException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        catch (TrustKeyProcessingException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        return RedirectBindingSignatureUtil.validateSignature((String)queryString, (PublicKey)validatingKey, (byte[])sigValue);
    }

    protected String getDestinationQueryString(String urlEncodedResponse, String urlEncodedRelayState) {
        try {
            PrivateKey signingKey = this.keyManager.getSigningKey();
            String url = RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature((String)urlEncodedResponse, (String)urlEncodedRelayState, (PrivateKey)signingKey);
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ResponseType getResponse(Request request, Principal userPrincipal) throws ParsingException, ConfigurationException, ProcessingException {
        SAML2Response saml2Response = new SAML2Response();
        ResponseType responseType = super.getResponse(request, userPrincipal);
        if (this.idpConfiguration.isEncrypt()) {
            String sp = responseType.getDestination();
            if (sp == null) {
                throw new IllegalStateException("Unable to handle encryption as SP url is null");
            }
            try {
                URL spurl = new URL(sp);
                PublicKey publicKey = this.keyManager.getValidatingKey(spurl.getHost());
                EncryptionType enc = this.idpConfiguration.getEncryption();
                if (enc == null) {
                    throw new IllegalStateException("EncryptionType not configured");
                }
                String encAlgo = enc.getEncAlgo().value();
                int keyLength = enc.getKeySize();
                SecretKey sk = this.keyManager.getEncryptionKey(spurl.getHost(), encAlgo, keyLength);
                StringWriter sw = new StringWriter();
                saml2Response.marshall(responseType, (Writer)sw);
                Document responseDoc = DocumentUtil.getDocument((Reader)new StringReader(sw.toString()));
                String assertionNS = JBossSAMLURIConstants.ASSERTION_NSURI.get();
                QName assertionQName = new QName(assertionNS, "EncryptedAssertion", "saml");
                Element encAssertion = XMLEncryptionUtil.encryptElementInDocument((Document)responseDoc, (PublicKey)publicKey, (SecretKey)sk, (int)keyLength, (QName)assertionQName, (boolean)true);
                EncryptedElementType eet = saml2Response.getEncryptedAssertion(DocumentUtil.getNodeAsStream((Node)encAssertion));
                responseType.getAssertionOrEncryptedAssertion().set(0, eet);
            }
            catch (MalformedURLException e) {
                throw new ParsingException((Throwable)e);
            }
            catch (JAXBException e) {
                throw new ParsingException((Throwable)e);
            }
            catch (SAXException e) {
                throw new ParsingException((Throwable)e);
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            StringWriter sw;
            block13: {
                sw = new StringWriter();
                try {
                    saml2Response.marshall(responseType, (Writer)sw);
                }
                catch (JAXBException e) {
                    if (this.trace) {
                        log.trace((Object)e);
                    }
                }
                catch (SAXException e) {
                    if (!this.trace) break block13;
                    log.trace((Object)e);
                }
            }
            log.trace((Object)("IDPRedirectValveWithSignature::Response=" + sw.toString()));
        }
        return responseType;
    }
}

