/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.bindings.util.ValveUtil;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.ServerDetector;
import org.w3c.dom.Document;

public class SPPostFormAuthenticator
extends BaseFormAuthenticator {
    private static Logger log = Logger.getLogger(SPPostFormAuthenticator.class);
    private final boolean trace = log.isTraceEnabled();
    private boolean jbossEnv = false;
    protected boolean supportSignatures = false;
    protected TrustKeyManager keyManager;
    protected boolean validateSignature = false;

    public SPPostFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw new RuntimeException("PL00026: Response was not of type catalina response");
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        boolean localLogout;
        Session session = request.getSessionInternal(true);
        String lloStr = request.getParameter("LLO");
        boolean bl = localLogout = StringUtil.isNotNull((String)lloStr) && "true".equalsIgnoreCase(lloStr);
        if (localLogout) {
            try {
                this.sendToLogoutPage(request, response, session);
            }
            catch (ServletException e) {
                log.error((Object)"Exception in logout::", (Throwable)e);
                throw new IOException(e);
            }
            return false;
        }
        String gloStr = request.getParameter("GLO");
        boolean logOutRequest = StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
        String samlRequest = request.getParameter("SAMLRequest");
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        if (!(principal == null || logOutRequest || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
            return true;
        }
        if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
            return this.generalUserRequest(request, response, loginConfig);
        }
        if (StringUtil.isNotNull((String)samlResponse)) {
            return this.handleSAMLResponse(request, response, loginConfig);
        }
        if (StringUtil.isNotNull((String)samlRequest)) {
            return this.handleSAMLRequest(request, response, loginConfig);
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean handleSAMLRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        String samlRequest = request.getParameter("SAMLRequest");
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        try {
            ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(true, this.serviceURL);
            requestProcessor.setTrustKeyManager(this.keyManager);
            requestProcessor.setSupportSignatures(this.supportSignatures);
            boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
            if (response.isCommitted() || response.isAppCommitted()) {
                return false;
            }
            if (result) {
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)"Server Exception:", (Throwable)e);
            throw new IOException("PL00032: Service Provider :: Server Exception");
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean handleSAMLResponse(Request request, Response response, LoginConfig loginConfig) throws IOException {
        SPUtil spUtil = new SPUtil();
        boolean isValid = false;
        Session session = request.getSessionInternal(true);
        String samlResponse = request.getParameter("SAMLResponse");
        String relayState = request.getParameter("RelayState");
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        Principal principal = request.getUserPrincipal();
        try {
            isValid = this.validate(request);
        }
        catch (Exception e) {
            log.error((Object)"Exception:", (Throwable)e);
            throw new IOException();
        }
        if (!isValid) {
            throw new IOException("PL00019: Validation check failed");
        }
        try {
            ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(true, this.serviceURL);
            responseProcessor.setValidateSignature(this.validateSignature);
            responseProcessor.setTrustKeyManager(this.keyManager);
            SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            willSendRequest = saml2HandlerResponse.getSendRequest();
            if (destination == null || samlResponseDocument == null) {
                boolean sessionValidity = session.isValid();
                if (!sessionValidity) {
                    this.sendToLogoutPage(request, response, session);
                    return false;
                }
                List roles = saml2HandlerResponse.getRoles();
                if (principal == null) {
                    principal = (Principal)session.getSession().getAttribute("picketlink.principal");
                }
                String username = principal.getName();
                String password = "EMPTY_STR";
                if (this.trace) {
                    log.trace((Object)("Roles determined for username=" + username + "=" + Arrays.toString(roles.toArray())));
                }
                if (new ServerDetector().isJboss() || this.jbossEnv) {
                    ServiceProviderSAMLContext.push(username, roles);
                    principal = this.context.getRealm().authenticate(username, password);
                    ServiceProviderSAMLContext.clear();
                } else {
                    principal = spUtil.createGenericPrincipal(request, username, roles);
                }
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                request.setUserPrincipal(principal);
                if (this.saveRestoreRequest) {
                    this.restoreRequest(request, session);
                }
                this.register(request, response, principal, "FORM", username, password);
                return true;
            }
            this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest);
        }
        catch (ProcessingException pe) {
            Throwable t = pe.getCause();
            if (t != null && t instanceof AssertionExpiredException) {
                log.error((Object)"Assertion has expired. Asking IDP for reissue");
                return this.generalUserRequest(request, response, loginConfig);
            }
            log.error((Object)"Server Exception:", (Throwable)pe);
            throw new IOException("PL00032: Service Provider :: Server Exception" + pe.getLocalizedMessage());
        }
        catch (Exception e) {
            log.error((Object)"Server Exception:", (Throwable)e);
            throw new IOException("PL00032: Service Provider :: Server Exception");
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean generalUserRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Session session = request.getSessionInternal(true);
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        String relayState = request.getParameter("RelayState");
        SAML2HandlerResponse saml2HandlerResponse = null;
        try {
            ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(true, this.serviceURL);
            if (this.issuerID != null) {
                baseProcessor.setIssuer(this.issuerID);
            }
            baseProcessor.setIdentityURL(this.identityURL);
            saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
        }
        catch (ProcessingException pe) {
            log.error((Object)"Processing Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ParsingException pe) {
            log.error((Object)"Parsing Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ConfigurationException pe) {
            log.error((Object)"Config Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        willSendRequest = saml2HandlerResponse.getSendRequest();
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        if (destination != null && samlResponseDocument != null) {
            try {
                if (this.saveRestoreRequest) {
                    this.saveRequest(request, session);
                }
                this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest);
                return false;
            }
            catch (Exception e) {
                log.error((Object)"Server Exception:", (Throwable)e);
                throw new IOException("PL00032: Service Provider :: Server Exception");
            }
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected String getBinding() {
        return JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
    }

    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws ProcessingException, ConfigurationException, IOException {
        String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
        samlMessage = PostBindingUtil.base64Encode((String)samlMessage);
        PostBindingUtil.sendPost((DestinationInfoHolder)new DestinationInfoHolder(destination, samlMessage, relayState), (HttpServletResponse)response, (boolean)willSendRequest);
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String domainsTrusted;
            String issuerDomain = ValveUtil.getDomain(issuer);
            TrustType idpTrust = this.spConfiguration.getTrust();
            if (idpTrust != null && (domainsTrusted = idpTrust.getDomains()).indexOf(issuerDomain) < 0) {
                throw new IssuerNotTrustedException(issuer);
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected ResponseType decryptAssertion(ResponseType responseType) {
        throw new RuntimeException("PL00027: Authenticator does not handle encryption");
    }
}

