/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.PBEUtils;
import org.picketlink.common.util.SecurityActions;

public class StringUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static boolean isNotNull(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String getSystemPropertyAsString(String str) {
        if (str == null) {
            throw logger.nullArgumentError("str");
        }
        if (str.contains("${")) {
            Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
            Matcher matcher = pattern.matcher(str);
            StringBuffer buffer = new StringBuffer();
            String sysPropertyValue = null;
            while (matcher.find()) {
                String subString = matcher.group(1);
                String defaultValue = "";
                if (subString.contains("::")) {
                    int index = subString.indexOf("::");
                    defaultValue = subString.substring(index + 2);
                    subString = subString.substring(0, index);
                }
                if ((sysPropertyValue = SecurityActions.getSystemProperty(subString, defaultValue)).isEmpty()) {
                    throw logger.systemPropertyMissingError(matcher.group(1));
                }
                sysPropertyValue = Matcher.quoteReplacement(sysPropertyValue);
                matcher.appendReplacement(buffer, sysPropertyValue);
            }
            matcher.appendTail(buffer);
            str = buffer.toString();
        }
        return str;
    }

    public static void match(String first, String second) {
        if (!first.equals(second)) {
            throw logger.notEqualError(first, second);
        }
    }

    public static List<String> tokenize(String str) {
        return StringUtil.tokenize(str, ",");
    }

    public static List<String> tokenize(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static Map<String, String> tokenizeKeyValuePair(String keyValuePairString) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> tokens = StringUtil.tokenize(keyValuePairString);
        for (String token : tokens) {
            int location = token.indexOf(61);
            map.put(token.substring(0, location), token.substring(location + 1));
        }
        return map;
    }

    public static String decode(String maskedString, String salt, int iterationCount) throws Exception {
        String pbeAlgo = "PBEwithMD5andDES";
        if (maskedString.startsWith("MASK-")) {
            String decodedValue;
            SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
            char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
            PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKey cipherKey = factory.generateSecret(keySpec);
            maskedString = maskedString.substring("MASK-".length());
            maskedString = decodedValue = PBEUtils.decode64(maskedString, pbeAlgo, cipherKey, cipherSpec);
        }
        return maskedString;
    }

    public static String[] split(String toSplit, String delimiter) {
        if (delimiter.length() != 1) {
            throw new IllegalArgumentException("Delimiter can only be one character in length");
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + 1);
        return new String[]{beforeDelimiter, afterDelimiter};
    }
}

