/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.picketlink.common.properties.FieldProperty;
import org.picketlink.common.properties.FieldPropertyImpl;
import org.picketlink.common.properties.MethodProperty;
import org.picketlink.common.properties.MethodPropertyImpl;
import org.picketlink.common.properties.Property;

public class Properties {
    private Properties() {
    }

    public static <V> FieldProperty<V> createProperty(Field field) {
        return new FieldPropertyImpl(field);
    }

    public static <V> MethodProperty<V> createProperty(Method method) {
        return new MethodPropertyImpl(method);
    }

    public static <V> Property<V> createProperty(Member member) {
        if (member instanceof Method) {
            return new MethodPropertyImpl((Method)Method.class.cast(member));
        }
        if (member instanceof Field) {
            return new FieldPropertyImpl((Field)Field.class.cast(member));
        }
        throw new IllegalArgumentException("Cannot make a property of " + member + " - it is neither a method or a field");
    }

    public static <V> boolean isProperty(Method method) {
        try {
            new MethodPropertyImpl(method);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

