/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.Serializable;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.TransformerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SamlCredential
implements Serializable {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final long serialVersionUID = -8496414959425288835L;
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerUtil.getTransformerFactory();
    private final String assertion;

    public SamlCredential(Element assertion) {
        if (assertion == null) {
            throw logger.nullArgumentError("assertion");
        }
        this.assertion = SamlCredential.assertionToString(assertion);
    }

    public SamlCredential(String assertion) {
        if (StringUtil.isNullOrEmpty(assertion)) {
            throw logger.nullArgumentError("assertion");
        }
        this.assertion = assertion;
    }

    public String getAssertionAsString() {
        return this.assertion;
    }

    public Element getAssertionAsElement() throws ProcessingException {
        return SamlCredential.assertionToElement(this.assertion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SamlCredential)) {
            return false;
        }
        SamlCredential that = (SamlCredential)obj;
        return this.assertion.equals(that.assertion);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.assertion.hashCode();
        return result;
    }

    public String toString() {
        return "SamlCredential[" + this.assertion + "]";
    }

    public static Element assertionToElement(String assertion) throws ProcessingException {
        try {
            Document document = DocumentUtil.getDocument(assertion);
            return (Element)document.getFirstChild();
        }
        catch (ConfigurationException e) {
            throw logger.processingError(e);
        }
        catch (ParsingException e) {
            throw logger.processingError(e);
        }
    }

    public static String assertionToString(Element assertion) {
        if (assertion == null) {
            throw logger.nullArgumentError("assertion");
        }
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(assertion);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

