/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.core.HTTPContext;

public abstract class BaseSAML2Handler
implements SAML2Handler {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected SAML2HandlerConfig handlerConfig = null;
    protected SAML2HandlerChainConfig handlerChainConfig = null;
    private ProviderType providerConfig;

    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        this.handlerConfig = handlerConfig;
    }

    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        this.handlerChainConfig = handlerChainConfig;
        this.providerConfig = (ProviderType)this.handlerChainConfig.getParameter("CONFIGURATION");
        if (!this.isSupportedProviderType(this.providerConfig)) {
            throw logger.unsupportedType(this.providerConfig.getClass().getName());
        }
    }

    public SAML2Handler.HANDLER_TYPE getType() {
        if (this.providerConfig instanceof IDPType) {
            return SAML2Handler.HANDLER_TYPE.IDP;
        }
        return SAML2Handler.HANDLER_TYPE.SP;
    }

    public void reset() throws ProcessingException {
    }

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public static HttpServletRequest getHttpRequest(SAML2HandlerRequest request) {
        HTTPContext context = (HTTPContext)request.getContext();
        return context.getRequest();
    }

    public static HttpSession getHttpSession(SAML2HandlerRequest request) {
        HTTPContext context = (HTTPContext)request.getContext();
        return context.getRequest().getSession(false);
    }

    protected ProviderType getProviderconfig() {
        return this.providerConfig;
    }

    private boolean isSupportedProviderType(ProviderType providerType) {
        if (providerType == null) {
            throw logger.nullArgumentError("ProviderType configuration.");
        }
        return providerType instanceof IDPType || providerType instanceof SPType;
    }
}

