/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.facebook;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.log4j.Logger;
import org.picketlink.social.facebook.FacebookProcessor;
import org.picketlink.social.facebook.SecurityActions;

public class FacebookAuthenticator
extends FormAuthenticator {
    protected static Logger log = Logger.getLogger(FacebookAuthenticator.class);
    protected boolean trace = log.isTraceEnabled();
    protected String returnURL;
    protected String clientID;
    protected String clientSecret;
    protected String scope = "email";
    protected List<String> roles = new ArrayList<String>();
    protected boolean saveRestoreRequest = true;
    protected FacebookProcessor processor;
    private Method theSuperRegisterMethod = null;

    public void setReturnURL(String returnURL) {
        this.returnURL = this.getSystemPropertyAsString(returnURL);
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRoleString(String roleStr) {
        if (roleStr == null) {
            throw new RuntimeException("Role String is null in configuration");
        }
        StringTokenizer st = new StringTokenizer(roleStr, ",");
        while (st.hasMoreElements()) {
            this.roles.add(st.nextToken());
        }
    }

    public void setSaveRestoreRequest(boolean saveRestoreRequest) {
        this.saveRestoreRequest = saveRestoreRequest;
    }

    public void start() throws LifecycleException {
        if (this.clientID == null) {
            throw new LifecycleException("clientID is not provided");
        }
        if (this.clientSecret == null) {
            throw new LifecycleException("clientSecret is not provided");
        }
        if (this.returnURL == null) {
            throw new LifecycleException("returnURL is not provided");
        }
        super.start();
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response, LoginConfig loginConfig) throws IOException {
        if (!(request instanceof Request)) {
            throw new IOException("Not of type Catalina request");
        }
        if (!(response instanceof Response)) {
            throw new IOException("Not of type Catalina response");
        }
        return this.authenticate((Request)request, (Response)response, loginConfig);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw new RuntimeException("Wrong type of response:" + response);
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        if (this.trace) {
            log.trace((Object)"authenticate");
        }
        if (this.processor == null) {
            this.processor = new FacebookProcessor(this.clientID, this.clientSecret, this.scope, this.returnURL, this.roles);
        }
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute("STATE");
        if (this.trace) {
            log.trace((Object)("state=" + state));
        }
        if (STATES.FINISH.name().equals(state)) {
            return true;
        }
        if (state == null || state.isEmpty()) {
            if (this.saveRestoreRequest) {
                this.saveRequest(request, request.getSessionInternal());
            }
            return this.processor.initialInteraction(request, response);
        }
        if (state.equals(STATES.AUTH.name())) {
            return this.processor.handleAuthStage((HttpServletRequest)request, (HttpServletResponse)response);
        }
        if (state.equals(STATES.AUTHZ.name())) {
            Principal principal = this.processor.getPrincipal(request, response, this.context.getRealm());
            if (principal == null) {
                log.error((Object)"Principal was null. Maybe login modules need to be configured properly.");
                response.sendError(403);
                return false;
            }
            String userName = principal.getName();
            request.getSessionInternal().setNote("org.apache.catalina.session.USERNAME", (Object)userName);
            request.getSessionInternal().setNote("org.apache.catalina.session.PASSWORD", (Object)"");
            request.setUserPrincipal(principal);
            if (this.saveRestoreRequest) {
                this.restoreRequest(request, request.getSessionInternal());
            }
            this.registerWithAuthenticatorBase(request, response, principal, userName);
            request.getSession().setAttribute("STATE", (Object)STATES.FINISH.name());
            return true;
        }
        return false;
    }

    protected void registerWithAuthenticatorBase(Request request, Response response, Principal principal, String userName) {
        block5: {
            try {
                this.register(request, response, principal, "FORM", userName, "");
            }
            catch (NoSuchMethodError nse) {
                if (this.theSuperRegisterMethod == null) {
                    Class[] args = new Class[]{Request.class, HttpServletResponse.class, Principal.class, String.class, String.class, String.class};
                    Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
                    this.theSuperRegisterMethod = SecurityActions.getMethod(superClass, "register", args);
                }
                if (this.theSuperRegisterMethod == null) break block5;
                Object[] objectArgs = new Object[]{request, response.getResponse(), principal, "FORM", userName, FacebookProcessor.EMPTY_PASSWORD};
                try {
                    this.theSuperRegisterMethod.invoke((Object)this, objectArgs);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to register:", (Throwable)e);
                }
            }
        }
    }

    protected String getSystemPropertyAsString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        if (str.contains("${")) {
            Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
            Matcher matcher = pattern.matcher(str);
            StringBuffer buffer = new StringBuffer();
            String sysPropertyValue = null;
            while (matcher.find()) {
                String subString = matcher.group(1);
                String defaultValue = "";
                if (subString.contains("::")) {
                    int index = subString.indexOf("::");
                    defaultValue = subString.substring(index + 2);
                    subString = subString.substring(0, index);
                }
                if ((sysPropertyValue = SecurityActions.getSystemProperty(subString, defaultValue)).isEmpty()) {
                    throw new IllegalArgumentException(String.valueOf(matcher.group(1)) + " is missing in system properties");
                }
                matcher.appendReplacement(buffer, sysPropertyValue);
            }
            matcher.appendTail(buffer);
            str = buffer.toString();
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }
}

