/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.facebook;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext createSecurityContext(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                try {
                    return SecurityContextFactory.createSecurityContext((String)name);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static Method getMethod(final Class<?> clazz, final String methodName, final Class<?>[] parameterTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    static Class<?> loadClass(final Class<?> theAskingClass, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader tcl = theAskingClass.getClassLoader();
                    return tcl.loadClass(fqn);
                }
                catch (Exception e) {
                    try {
                        return Thread.currentThread().getContextClassLoader().loadClass(fqn);
                    }
                    catch (ClassNotFoundException e1) {
                        return null;
                    }
                }
            }
        });
    }
}

