/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathException;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtil {
    private static Logger log = Logger.getLogger(DocumentUtil.class);
    private static boolean trace = log.isTraceEnabled();

    public static boolean containsNode(Document doc, Node node) {
        if (node.getNodeType() == 1) {
            Element elem = (Element)node;
            NodeList nl = doc.getElementsByTagNameNS(elem.getNamespaceURI(), elem.getLocalName());
            return nl != null && nl.getLength() > 0;
        }
        throw new UnsupportedOperationException();
    }

    public static Document createDocument() throws ConfigurationException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentUtil.getDocumentBuilderFactory();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        return builder.newDocument();
    }

    public static Document getDocument(String docString) throws ConfigurationException, ParsingException, ProcessingException {
        return DocumentUtil.getDocument(new StringReader(docString));
    }

    public static Document getDocument(Reader reader) throws ConfigurationException, ProcessingException, ParsingException {
        try {
            DocumentBuilderFactory factory = DocumentUtil.getDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(reader));
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ParsingException(e);
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
    }

    public static Document getDocument(File file) throws ConfigurationException, ProcessingException, ParsingException {
        DocumentBuilderFactory factory = DocumentUtil.getDocumentBuilderFactory();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ParsingException(e);
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
    }

    public static Document getDocument(InputStream is) throws ConfigurationException, ProcessingException, ParsingException {
        DocumentBuilderFactory factory = DocumentUtil.getDocumentBuilderFactory();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ParsingException(e);
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
    }

    public static String getDocumentAsString(Document signedDoc) throws ProcessingException, ConfigurationException {
        DOMSource source = new DOMSource(signedDoc);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        Transformer xformer = DocumentUtil.getTransformer();
        try {
            xformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw new ProcessingException(e);
        }
        return sw.toString();
    }

    public static String getDOMElementAsString(Element element) throws ProcessingException, ConfigurationException {
        DOMSource source = new DOMSource(element);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        Transformer xformer = DocumentUtil.getTransformer();
        try {
            xformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw new ProcessingException(e);
        }
        return sw.toString();
    }

    public static InputStream getNodeAsStream(Node node) throws ConfigurationException, ProcessingException {
        DOMSource source = new DOMSource(node);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = DocumentUtil.getTransformer();
        try {
            transformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw new ProcessingException(e);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        return bis;
    }

    public static String getNodeAsString(Node node) throws ConfigurationException, ProcessingException {
        DOMSource source = new DOMSource(node);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = DocumentUtil.getTransformer();
        try {
            transformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw new ProcessingException(e);
        }
        return new String(baos.toByteArray());
    }

    public static Node getNodeWithAttribute(Document document, String nsURI, String nodeName, String attributeName, String attributeValue) throws XPathException, TransformerFactoryConfigurationError, TransformerException {
        NodeList nl = document.getElementsByTagNameNS(nsURI, nodeName);
        int len = nl != null ? nl.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element el = (Element)n;
            String attrValue = el.getAttributeNS(nsURI, attributeName);
            if (attributeValue.equals(attrValue)) {
                return el;
            }
            attrValue = el.getAttribute(attributeName);
            if (!attributeValue.equals(attrValue)) continue;
            return el;
        }
        return null;
    }

    public static Document normalizeNamespaces(Document doc) {
        DOMConfiguration docConfig = doc.getDomConfig();
        docConfig.setParameter("namespaces", Boolean.TRUE);
        doc.normalizeDocument();
        return doc;
    }

    public static Source getXMLSource(Document doc) {
        return new DOMSource(doc);
    }

    public static String asString(Document doc) {
        String str = null;
        try {
            str = DocumentUtil.getDocumentAsString(doc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static void logNodes(Document doc) {
        DocumentUtil.visit(doc, 0);
    }

    private static void visit(Node node, int level) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (trace) {
                log.trace((Object)("Node=" + childNode.getNamespaceURI() + "::" + childNode.getLocalName()));
            }
            DocumentUtil.visit(childNode, level + 1);
        }
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
        return factory;
    }

    private static Transformer getTransformer() throws ProcessingException, ConfigurationException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ConfigurationException(e);
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        return transformer;
    }
}

