/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins.saml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.core.wstrust.SecurityTokenProvider;
import org.picketlink.identity.federation.core.wstrust.StandardSecurityToken;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestContext;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.KeyInfoConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML20TokenProvider
implements SecurityTokenProvider {
    private static Logger logger = Logger.getLogger(SAML20TokenProvider.class);
    private static final String CANCELED_IDS_FILE = "CanceledIdsFile";
    private Set<String> cancelledIds;
    private File canceledIdsFile;
    private Map<String, String> properties;

    @Override
    public void initialize(Map<String, String> properties) {
        this.properties = properties;
        this.cancelledIds = new HashSet<String>();
        String file = this.properties.get(CANCELED_IDS_FILE);
        if (file == null && logger.isDebugEnabled()) {
            logger.debug((Object)"File to store canceled ids has not been specified: ids will not be persisted!");
        } else if (file != null) {
            this.canceledIdsFile = new File(file);
            this.loadCanceledIds();
        }
    }

    @Override
    public void cancelToken(WSTrustRequestContext context) throws WSTrustException {
        Element token = context.getRequestSecurityToken().getCancelTargetElement();
        if (token == null) {
            throw new WSTrustException("Invalid cancel request: missing required CancelTarget");
        }
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isAssertion(assertionElement)) {
            throw new WSTrustException("CancelTarget doesn't not contain a SAMLV2.0 assertion");
        }
        String assertionId = assertionElement.getAttribute("ID");
        this.storeCanceledId(assertionId);
    }

    @Override
    public void issueToken(WSTrustRequestContext context) throws WSTrustException {
        String assertionID = IDGenerator.create("ID_");
        Lifetime lifetime = context.getRequestSecurityToken().getLifetime();
        AudienceRestrictionType restriction = null;
        AppliesTo appliesTo = context.getRequestSecurityToken().getAppliesTo();
        if (appliesTo != null) {
            restriction = SAMLAssertionFactory.createAudienceRestriction(WSTrustUtil.parseAppliesTo(appliesTo));
        }
        ConditionsType conditions = SAMLAssertionFactory.createConditions(lifetime.getCreated(), lifetime.getExpires(), restriction);
        String confirmationMethod = null;
        KeyInfoConfirmationDataType keyInfoDataType = null;
        if (context.getProofTokenInfo() != null) {
            confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
            keyInfoDataType = SAMLAssertionFactory.createKeyInfoConfirmation(context.getProofTokenInfo());
        } else {
            confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        }
        SubjectConfirmationType subjectConfirmation = SAMLAssertionFactory.createSubjectConfirmation(null, confirmationMethod, keyInfoDataType);
        Principal principal = context.getCallerPrincipal();
        String subjectName = principal == null ? "ANONYMOUS" : principal.getName();
        NameIDType nameID = SAMLAssertionFactory.createNameID(null, "urn:picketlink:identity-federation", subjectName);
        SubjectType subject = SAMLAssertionFactory.createSubject(nameID, subjectConfirmation);
        ArrayList<StatementAbstractType> statements = null;
        Map<String, Object> claimedAttributes = context.getClaimedAttributes();
        if (claimedAttributes != null) {
            statements = new ArrayList<StatementAbstractType>();
            statements.add(StatementUtil.createAttributeStatement(claimedAttributes));
        }
        NameIDType issuerID = SAMLAssertionFactory.createNameID(null, null, context.getTokenIssuer());
        AssertionType assertion = SAMLAssertionFactory.createAssertion(assertionID, issuerID, lifetime.getCreated(), conditions, subject, statements);
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(assertion);
        }
        catch (Exception e) {
            throw new WSTrustException("Failed to marshall SAMLV2 assertion", e);
        }
        StandardSecurityToken token = new StandardSecurityToken(context.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        context.setSecurityToken(token);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        context.setAttachedReference(attachedReference);
    }

    @Override
    public void renewToken(WSTrustRequestContext context) throws WSTrustException {
        Element token = context.getRequestSecurityToken().getRenewTargetElement();
        if (token == null) {
            throw new WSTrustException("Invalid renew request: missing required RenewTarget");
        }
        Element oldAssertionElement = (Element)token.getFirstChild();
        if (!this.isAssertion(oldAssertionElement)) {
            throw new WSTrustException("RenewTarget doesn't not contain a SAMLV2.0 assertion");
        }
        AssertionType oldAssertion = null;
        try {
            oldAssertion = SAMLUtil.fromElement(oldAssertionElement);
        }
        catch (JAXBException je) {
            throw new WSTrustException("Error unmarshalling assertion", je);
        }
        if (this.cancelledIds.contains(oldAssertion.getID())) {
            throw new WSTrustException("Assertion with id " + oldAssertion.getID() + " is canceled and cannot be renewed");
        }
        ConditionsType conditions = oldAssertion.getConditions();
        conditions.setNotBefore(context.getRequestSecurityToken().getLifetime().getCreated());
        conditions.setNotOnOrAfter(context.getRequestSecurityToken().getLifetime().getExpires());
        String assertionID = IDGenerator.create("ID_");
        AssertionType newAssertion = SAMLAssertionFactory.createAssertion(assertionID, oldAssertion.getIssuer(), context.getRequestSecurityToken().getLifetime().getCreated(), conditions, oldAssertion.getSubject(), oldAssertion.getStatementOrAuthnStatementOrAuthzDecisionStatement());
        Element assertionElement = null;
        try {
            assertionElement = SAMLUtil.toElement(newAssertion);
        }
        catch (Exception e) {
            throw new WSTrustException("Failed to marshall SAMLV2 assertion", e);
        }
        StandardSecurityToken securityToken = new StandardSecurityToken(context.getRequestSecurityToken().getTokenType().toString(), assertionElement, assertionID);
        context.setSecurityToken(securityToken);
        KeyIdentifierType keyIdentifier = WSTrustUtil.createKeyIdentifier("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", "#" + assertionID);
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        attributes.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType"), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        RequestedReferenceType attachedReference = WSTrustUtil.createRequestedReference(keyIdentifier, attributes);
        context.setAttachedReference(attachedReference);
    }

    @Override
    public void validateToken(WSTrustRequestContext context) throws WSTrustException {
        Element token;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SAML V2.0 token validation started");
        }
        if ((token = context.getRequestSecurityToken().getValidateTargetElement()) == null) {
            throw new WSTrustException("Bad validate request: missing required ValidateTarget");
        }
        String code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid";
        String reason = "SAMLV2.0 Assertion successfuly validated";
        AssertionType assertion = null;
        Element assertionElement = (Element)token.getFirstChild();
        if (!this.isAssertion(assertionElement)) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: supplied token is not a SAMLV2.0 Assertion";
        } else {
            try {
                assertion = SAMLUtil.fromElement(assertionElement);
            }
            catch (JAXBException e) {
                throw new WSTrustException("Unmarshalling error:", e);
            }
        }
        if (this.cancelledIds.contains(assertion.getID())) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: assertion with id " + assertion.getID() + " is canceled";
        }
        try {
            if (AssertionUtil.hasExpired(assertion)) {
                code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
                reason = "Validation failure: assertion expired or used before its lifetime period";
            }
        }
        catch (Exception ce) {
            code = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid";
            reason = "Validation failure: unable to verify assertion lifetime: " + ce.getMessage();
        }
        StatusType status = new StatusType();
        status.setCode(code);
        status.setReason(reason);
        context.setStatus(status);
    }

    private boolean isAssertion(Element element) {
        return element == null ? false : "Assertion".equals(element.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(element.getNamespaceURI());
    }

    private void loadCanceledIds() {
        try {
            if (!this.canceledIdsFile.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("File " + this.canceledIdsFile.getCanonicalPath() + " doesn't exist and will be created"));
                }
                this.canceledIdsFile.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(this.canceledIdsFile));
            String id = reader.readLine();
            while (id != null) {
                this.cancelledIds.add(id);
                id = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error opening canceled ids file: " + ioe.getMessage()));
            }
            ioe.printStackTrace();
        }
    }

    public synchronized void storeCanceledId(String id) {
        if (this.canceledIdsFile != null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.canceledIdsFile, true));
                writer.write(id + "\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.cancelledIds.add(id);
    }
}

