/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.handlers;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class STSSecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String USERNAME_MSG_CONTEXT_PROPERTY = "org.picketlink.identity.federation.core.wstrust.handlers.username";
    public static final String PASSWORD_MSG_CONTEXT_PROPERTY = "org.picketlink.identity.federation.core.wstrust.handlers.password";
    private String configFile = "sts-client.properties";
    private STSClientConfig.Builder configBuilder;

    public abstract QName getSecurityElementQName();

    public abstract QName getTokenElementQName();

    @PostConstruct
    public void parseSTSConfig() {
        this.configBuilder = new STSClientConfig.Builder(this.configFile);
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        if (this.isOutBound(messageContext)) {
            return true;
        }
        try {
            Element securityToken = this.extractSecurityToken(messageContext, this.getSecurityElementQName(), this.getTokenElementQName());
            this.setUsernameFromMessageContext(messageContext, this.configBuilder);
            this.setPasswordFromMessageContext(messageContext, this.configBuilder);
            STSClient stsClient = this.createSTSClient(this.configBuilder);
            boolean valid = stsClient.validateToken(securityToken);
            if (valid) {
                return true;
            }
            throw new WebServiceException("Could not validate security token " + securityToken);
        }
        catch (SOAPException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
        catch (WSTrustException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
        catch (ParsingException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
    }

    private Element extractSecurityToken(SOAPMessageContext messageContext, QName securityQName, QName tokenQName) throws SOAPException {
        if (securityQName == null) {
            throw new IllegalStateException("securityQName from subclass cannot be null!");
        }
        if (tokenQName == null) {
            throw new IllegalStateException("tokenQName from subclass cannot be null!");
        }
        SOAPHeader soapHeader = messageContext.getMessage().getSOAPHeader();
        Iterator securityHeaders = soapHeader.getChildElements(securityQName);
        while (securityHeaders.hasNext()) {
            Iterator childElements;
            SOAPHeaderElement elem = (SOAPHeaderElement)securityHeaders.next();
            if (!elem.getElementQName().equals(securityQName) || !(childElements = elem.getChildElements(tokenQName)).hasNext()) continue;
            return (Element)childElements.next();
        }
        return null;
    }

    private void setUsernameFromMessageContext(SOAPMessageContext context, STSClientConfig.Builder builder) {
        String username = (String)context.get((Object)USERNAME_MSG_CONTEXT_PROPERTY);
        if (username != null) {
            this.configBuilder.username(username);
        }
    }

    private void setPasswordFromMessageContext(SOAPMessageContext context, STSClientConfig.Builder builder) {
        String password = (String)context.get((Object)PASSWORD_MSG_CONTEXT_PROPERTY);
        if (password != null) {
            this.configBuilder.password(password);
        }
    }

    public Set<QName> getHeaders() {
        return Collections.singleton(this.getSecurityElementQName());
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    @Resource(name="STSClientConfig")
    public void setConfigFile(String configFile) {
        if (configFile != null) {
            this.configFile = configFile;
        }
    }

    STSClientConfig.Builder getConfigBuilder() {
        return this.configBuilder;
    }

    STSClient createSTSClient(STSClientConfig.Builder builder) throws ParsingException {
        return STSClientFactory.getInstance().create(builder.build());
    }

    private boolean isOutBound(SOAPMessageContext messageContext) {
        return (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
    }
}

