/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.wstrust;

import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.w3c.dom.Element;

public class WSTrustClient {
    private STSClient stsClient;

    public WSTrustClient(String serviceName, String port, String endpointURI, SecurityInfo secInfo) throws ParsingException {
        STSClientConfig.Builder builder = new STSClientConfig.Builder();
        builder.serviceName(serviceName).portName(port).endpointAddress(endpointURI).username(secInfo.username).password(secInfo.passwd);
        this.stsClient = STSClientFactory.getInstance().create(builder.build());
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        return this.stsClient.issueToken(tokenType);
    }

    public Element issueTokenForEndpoint(String endpointURI) throws WSTrustException {
        return this.stsClient.issueTokenForEndpoint(endpointURI);
    }

    public Element issueToken(String endpointURI, String tokenType) throws WSTrustException {
        return this.stsClient.issueToken(endpointURI, tokenType);
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        return this.stsClient.renewToken(tokenType, token);
    }

    public boolean validateToken(Element token) throws WSTrustException {
        return this.stsClient.validateToken(token);
    }

    public static class SecurityInfo {
        private String username;
        private String passwd;

        public SecurityInfo(String name, char[] pass) {
            this.username = name;
            this.passwd = new String(pass);
        }

        public SecurityInfo(String name, String pass) {
            this.username = name;
            this.passwd = pass;
        }
    }
}

