/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;

public class KeyStoreUtil {
    public static KeyStore getKeyStore(File keyStoreFile, char[] storePass) throws GeneralSecurityException, IOException {
        FileInputStream fis = new FileInputStream(keyStoreFile);
        return KeyStoreUtil.getKeyStore(fis, storePass);
    }

    public static KeyStore getKeyStore(String fileURL, char[] storePass) throws GeneralSecurityException, IOException {
        if (fileURL == null) {
            throw new IllegalArgumentException("fileURL is null");
        }
        File file = new File(fileURL);
        FileInputStream fis = new FileInputStream(file);
        return KeyStoreUtil.getKeyStore(fis, storePass);
    }

    public static KeyStore getKeyStore(URL url, char[] storePass) throws GeneralSecurityException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        return KeyStoreUtil.getKeyStore(url.openStream(), storePass);
    }

    public static KeyStore getKeyStore(InputStream ksStream, char[] storePass) throws GeneralSecurityException, IOException {
        if (ksStream == null) {
            throw new IllegalArgumentException("InputStream for the KeyStore is null");
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(ksStream, storePass);
        return ks;
    }

    public static KeyPair generateKeyPair(String algo) throws GeneralSecurityException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algo);
        return kpg.genKeyPair();
    }

    public static PublicKey getPublicKey(KeyStore ks, String alias, char[] password) throws KeyStoreException, NoSuchAlgorithmException, GeneralSecurityException {
        Certificate cert;
        PublicKey publicKey = null;
        Key key = ks.getKey(alias, password);
        if (key instanceof PrivateKey) {
            cert = ks.getCertificate(alias);
            publicKey = cert.getPublicKey();
        }
        if (publicKey == null && (cert = ks.getCertificate(alias)) != null) {
            publicKey = cert.getPublicKey();
        }
        return publicKey;
    }

    public static void addCertificate(File keystoreFile, char[] storePass, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStoreUtil.getKeyStore(keystoreFile, storePass);
        keystore.setCertificateEntry(alias, cert);
        FileOutputStream out = new FileOutputStream(keystoreFile);
        keystore.store(out, storePass);
        out.close();
    }
}

