/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSTSLoginModule
implements LoginModule {
    private Logger log = Logger.getLogger(AbstractSTSLoginModule.class);
    public static final String SHARED_TOKEN = "org.picketlink.identity.federation.core.wstrust.lm.stsToken";
    public static final String OPTIONS_CREDENTIALS = "useOptionsCredentials";
    public static final String OPTIONS_PW_STACKING = "password-stacking";
    public static final String STS_CONFIG_FILE = "configFile";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Element samlToken;
    private boolean success;
    private Map<String, ?> options;
    private Map<String, ?> sharedState;
    private boolean passwordStacking;
    private boolean useFirstPass;
    private boolean useOptionsCredentials;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Boolean useOptionsCreds;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        this.sharedState = sharedState;
        String pwStackingOption = (String)options.get(OPTIONS_PW_STACKING);
        boolean bl = this.passwordStacking = pwStackingOption != null;
        if (this.passwordStacking) {
            this.useFirstPass = "useFirstPass".equals(pwStackingOption);
        }
        if ((useOptionsCreds = Boolean.valueOf((String)options.get(OPTIONS_CREDENTIALS))) != null) {
            this.useOptionsCredentials = useOptionsCreds;
        }
    }

    @Override
    public boolean login() throws LoginException {
        try {
            STSClient stsClient;
            Element token;
            STSClientConfig.Builder builder = new STSClientConfig.Builder(this.getRequiredOption(this.getOptions(), STS_CONFIG_FILE));
            if (this.useOptionsCredentials) {
                this.useCredentialsFromOptions(builder, this.options);
            } else if (this.isUseFirstPass()) {
                this.useCredentialsFromSharedState(builder);
            } else {
                this.useCredentialsFromCallback(builder);
            }
            if (this.passwordStacking) {
                this.setPasswordStackingCredentials(builder);
            }
            if ((token = this.invokeSTS(stsClient = this.createWSTrustClient(builder.build()))) == null) {
                throw new LoginException("Could not issue a SAML Security Token");
            }
            this.setSuccess(true);
            this.setSamlToken(token);
            this.setSharedToken(token);
            return true;
        }
        catch (WSTrustException e) {
            throw new LoginException("WSTrustException : " + e.getMessage());
        }
    }

    public abstract Element invokeSTS(STSClient var1) throws WSTrustException, LoginException;

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            SamlCredential samlCredential = new SamlCredential(this.samlToken);
            boolean added = this.subject.getPublicCredentials().add(samlCredential);
            this.populateSubject();
            if (added && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Added Credential :" + samlCredential));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.success = false;
        this.clearState();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.clearState();
        return true;
    }

    protected void useCredentialsFromCallback(STSClientConfig.Builder builder) throws LoginException {
        NameCallback nameCallback = new NameCallback("user:");
        PasswordCallback passwordCallback = new PasswordCallback("password:", true);
        try {
            this.getCallbackHandler().handle(new Callback[]{nameCallback, passwordCallback});
            builder.username(nameCallback.getName()).password(new String(passwordCallback.getPassword()));
        }
        catch (IOException e) {
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
    }

    private void setPasswordStackingCredentials(STSClientConfig.Builder builder) {
        Map<String, ?> sharedState = this.sharedState;
        sharedState.put("javax.security.auth.login.name", builder.getUsername());
        sharedState.put("javax.security.auth.login.password", builder.getPassword());
    }

    protected void useCredentialsFromSharedState(STSClientConfig.Builder builder) {
        builder.username(this.getSharedUsername()).password(new String(this.getSharedPassword()));
    }

    protected void useCredentialsFromOptions(STSClientConfig.Builder builder, Map<String, ?> options2) {
    }

    protected STSClientConfig getConfiguration(Map<String, ?> options) {
        String configFile = this.getRequiredOption(options, STS_CONFIG_FILE);
        return new STSClientConfig.Builder(configFile).build();
    }

    protected STSClient createWSTrustClient(STSClientConfig config) {
        try {
            return STSClientFactory.getInstance().create(config);
        }
        catch (ParsingException e) {
            throw new IllegalStateException("Could not create WSTrustClient:", e);
        }
    }

    protected String getRequiredOption(Map<String, ?> options, String optionName) {
        String option = (String)options.get(optionName);
        if (option == null) {
            throw new IllegalArgumentException("Required option '" + optionName + "' was missing from the login modules configuration");
        }
        return option;
    }

    protected boolean isSuccess() {
        return this.success;
    }

    protected void setSuccess(boolean success) {
        this.success = success;
    }

    protected Subject getSubject() {
        return this.subject;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    protected void setSamlToken(Element samlToken) {
        this.samlToken = samlToken;
    }

    protected void setSharedToken(Object token) {
        if (this.sharedState == null) {
            return;
        }
        Map<String, ?> state = this.sharedState;
        state.put(SHARED_TOKEN, token);
    }

    protected Object getSharedToken() {
        if (this.sharedState == null) {
            return null;
        }
        return this.sharedState.get(SHARED_TOKEN);
    }

    protected Map<String, ?> getOptions() {
        return this.options;
    }

    protected String getSharedUsername() {
        if (this.sharedState == null) {
            return null;
        }
        return (String)this.sharedState.get("javax.security.auth.login.name");
    }

    protected char[] getSharedPassword() {
        if (this.sharedState == null) {
            return null;
        }
        Object object = this.sharedState.get("javax.security.auth.login.password");
        if (object instanceof char[]) {
            return (char[])object;
        }
        if (object instanceof String) {
            return ((String)object).toCharArray();
        }
        return null;
    }

    protected boolean isUseFirstPass() {
        return this.useFirstPass;
    }

    protected boolean isUsePasswordStacking() {
        return this.passwordStacking;
    }

    protected boolean isUseOptionsConfig() {
        return this.useOptionsCredentials;
    }

    private void clearState() {
        this.removeAllSamlCredentials(this.subject);
        this.samlToken = null;
    }

    private void removeAllSamlCredentials(Subject subject) {
        Set<SamlCredential> samlCredentials = subject.getPublicCredentials(SamlCredential.class);
        if (!samlCredentials.isEmpty()) {
            subject.getPublicCredentials().removeAll(samlCredentials);
        }
    }

    protected void populateSubject() {
        MappingManager mappingManager = this.getMappingManager();
        if (mappingManager == null) {
            return;
        }
        MappingContext principalMappingContext = mappingManager.getMappingContext(MappingType.PRINCIPAL.toString());
        MappingContext roleMappingContext = mappingManager.getMappingContext(MappingType.ROLE.toString());
        HashMap<String, Element> contextMap = new HashMap<String, Element>();
        contextMap.put(SHARED_TOKEN, this.samlToken);
        if (principalMappingContext != null) {
            principalMappingContext.performMapping(contextMap, null);
            Principal principal = (Principal)principalMappingContext.getMappingResult().getMappedObject();
            this.subject.getPrincipals().add(principal);
        }
        if (roleMappingContext != null) {
            roleMappingContext.performMapping(contextMap, null);
            RoleGroup group = (RoleGroup)roleMappingContext.getMappingResult().getMappedObject();
            SimpleGroup rolePrincipal = new SimpleGroup(group.getRoleName());
            for (Role role : group.getRoles()) {
                rolePrincipal.addMember((Principal)new SimplePrincipal(role.getRoleName()));
            }
            this.subject.getPrincipals().add((Principal)rolePrincipal);
        }
    }

    protected MappingManager getMappingManager() {
        SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
        if (securityContext == null) {
            return null;
        }
        return securityContext.getMappingManager();
    }
}

