/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.impl.EmptyAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.SecurityActions;

public class SAML2AttributeHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2AttributeHandler.class);
    private final boolean trace = log.isTraceEnabled();
    protected AttributeManager attribManager = new EmptyAttributeManager();
    protected List<String> attributeKeys = new ArrayList<String>();
    protected boolean chooseFriendlyName = false;

    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        super.initChainConfig(handlerChainConfig);
        Object config = this.handlerChainConfig.getParameter("CONFIGURATION");
        if (config instanceof IDPType) {
            IDPType idpType = (IDPType)config;
            String attribStr = idpType.getAttributeManager();
            this.insantiateAttributeManager(attribStr);
        }
    }

    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        String chooseFriendlyNameStr;
        super.initHandlerConfig(handlerConfig);
        String attribStr = (String)this.handlerConfig.getParameter("ATTRIBUTE_MANAGER");
        this.insantiateAttributeManager(attribStr);
        List ak = (List)this.handlerConfig.getParameter("ATTRIBUTE_KEYS");
        if (ak != null) {
            this.attributeKeys.addAll(ak);
        }
        if (StringUtil.isNotNull(chooseFriendlyNameStr = (String)handlerConfig.getParameter("ATTRIBUTE_CHOOSE_FRIENDLY_NAME"))) {
            this.chooseFriendlyName = Boolean.parseBoolean(chooseFriendlyNameStr);
        }
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof LogoutRequestType) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.SP) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        Map<String, Object> attribs = (Map<String, Object>)session.getAttribute("ATTRIBUTES");
        if (attribs == null) {
            attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
            session.setAttribute("ATTRIBUTES", attribs);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            return;
        }
        this.handleIDPResponse(request);
    }

    private void insantiateAttributeManager(String attribStr) throws ConfigurationException {
        if (attribStr != null && !"".equals(attribStr)) {
            try {
                this.attribManager = (AttributeManager)SecurityActions.loadClass(this.getClass(), attribStr).newInstance();
                if (this.trace) {
                    log.trace((Object)("AttributeManager set to " + this.attribManager));
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception initializing attribute manager:", (Throwable)e);
                throw new ConfigurationException();
            }
        }
    }

    protected void handleIDPResponse(SAML2HandlerRequest request) {
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        AssertionType assertion = (AssertionType)request.getOptions().get("ASSERTION");
        if (assertion == null) {
            throw new RuntimeException("PL00092: Null Value:Assertion not found in the handler request:" + request.getOptions());
        }
        Set<StatementAbstractType> statements = assertion.getStatements();
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attrStat = (AttributeStatementType)statement;
            List<AttributeStatementType.ASTChoiceType> attrs = attrStat.getAttributes();
            for (AttributeStatementType.ASTChoiceType attrChoice : attrs) {
                AttributeType attr = attrChoice.getAttribute();
                HashMap<String, List<Object>> attrMap = (HashMap<String, List<Object>>)session.getAttribute("SESSION_ATTRIBUTE_MAP");
                if (attrMap == null) {
                    attrMap = new HashMap<String, List<Object>>();
                    session.setAttribute("SESSION_ATTRIBUTE_MAP", attrMap);
                }
                if (this.chooseFriendlyName) {
                    attrMap.put(attr.getFriendlyName(), attr.getAttributeValue());
                    continue;
                }
                attrMap.put(attr.getName(), attr.getAttributeValue());
            }
        }
    }
}

