/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.factories;

import java.security.Principal;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.picketlink.identity.federation.core.factories.SecurityActions;

public class JBossAuthCacheInvalidationFactory {
    public static TimeCacheExpiry getCacheExpiry() {
        return ExpiringPrincipalCacheInvalidation.get();
    }

    protected static class ExpiringPrincipalCacheInvalidation
    implements TimeCacheExpiry {
        protected static ExpiringPrincipalCacheInvalidation _instance = null;
        protected static String objectName = "jboss.security:service=JaasSecurityManager";
        protected static Timer timer = new Timer();

        protected ExpiringPrincipalCacheInvalidation() {
        }

        protected static ExpiringPrincipalCacheInvalidation get() {
            if (_instance == null) {
                _instance = new ExpiringPrincipalCacheInvalidation();
            }
            return _instance;
        }

        protected static void setObjectName(String oName) {
            objectName = oName;
        }

        public void register(final String securityDomain, Date expiry, final Principal principal) {
            try {
                timer.schedule(new TimerTask(){

                    public void run() {
                        try {
                            ObjectName on = new ObjectName(objectName);
                            MBeanServer server = SecurityActions.getJBossMBeanServer();
                            Object[] obj = new Object[]{securityDomain, principal};
                            String[] sig = new String[]{"java.lang.String", "java.security.Principal"};
                            server.invoke(on, "flushAuthenticationCache", obj, sig);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, expiry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface TimeCacheExpiry {
        public void register(String var1, Date var2, Principal var3);
    }
}

