/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAML11AssertionParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusCodeType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusType;
import org.w3c.dom.Element;

public class SAML11ResponseParser
implements ParserNamespaceSupport {
    private final String RESPONSE = JBossSAMLConstants.RESPONSE.get();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.RESPONSE);
        Attribute idAttr = startElement.getAttributeByName(new QName("ResponseID"));
        if (idAttr == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: ResponseID");
        }
        String id = StaxParserUtil.getAttributeValue(idAttr);
        Attribute issueInstant = startElement.getAttributeByName(new QName("IssueInstant"));
        if (issueInstant == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: IssueInstant");
        }
        XMLGregorianCalendar issueInstantVal = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstant));
        SAML11ResponseType response = new SAML11ResponseType(id, issueInstantVal);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                Element sig = StaxParserUtil.getDOMElement(xmlEventReader);
                response.setSignature(sig);
                continue;
            }
            if (JBossSAMLConstants.ASSERTION.get().equals(elementName)) {
                SAML11AssertionParser assertionParser = new SAML11AssertionParser();
                response.add((SAML11AssertionType)assertionParser.parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.STATUS.get().equals(elementName)) {
                response.setStatus(this.parseStatus(xmlEventReader));
                continue;
            }
            throw new RuntimeException("PL00064: Parser: Unknown Start Element: ::location=" + startElement.getLocation());
        }
        return response;
    }

    protected SAML11StatusType parseStatus(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String STATUS = JBossSAMLConstants.STATUS.get();
        StaxParserUtil.validate(startElement, STATUS);
        SAML11StatusType status = new SAML11StatusType();
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            EndElement endElement;
            XMLEvent xmlEvent;
            QName startElementName = startElement.getName();
            String elementTag = startElementName.getLocalPart();
            SAML11StatusCodeType statusCode = null;
            if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                Attribute valueAttr = startElement.getAttributeByName(new QName("Value"));
                if (valueAttr != null) {
                    statusCode = new SAML11StatusCodeType(new QName(StaxParserUtil.getAttributeValue(valueAttr)));
                }
                status.setStatusCode(statusCode);
                startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                elementTag = startElement.getName().getLocalPart();
                if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                    SAML11StatusCodeType subStatusCodeType = null;
                    startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                    Attribute subValueAttr = startElement.getAttributeByName(new QName("Value"));
                    if (subValueAttr != null) {
                        subStatusCodeType = new SAML11StatusCodeType(new QName(StaxParserUtil.getAttributeValue(subValueAttr)));
                    }
                    statusCode.setStatusCode(subStatusCodeType);
                    EndElement endElement2 = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement2, JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
            }
            if (!((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement) || StaxParserUtil.matches(endElement = StaxParserUtil.getNextEndElement(xmlEventReader), STATUS)) break;
            throw new RuntimeException("PL00061: Parser: Unknown End Element:" + StaxParserUtil.getEndElementName(endElement));
        }
        return status;
    }

    public boolean supports(QName qname) {
        return "urn:oasis:names:tc:SAML:1.0:protocol".equals(qname.getNamespaceURI()) && this.RESPONSE.equals(qname.getLocalPart());
    }
}

