/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.GeneralSecurityException;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11AssertionWriter;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLUtil {
    protected static Logger log = Logger.getLogger(SAMLUtil.class);
    protected static boolean trace = log.isTraceEnabled();
    public static final String SAML11_BEARER_URI = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    public static final String SAML11_HOLDER_OF_KEY_URI = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    public static final String SAML11_SENDER_VOUCHES_URI = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    public static final String SAML2_BEARER_URI = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    public static final String SAML2_HOLDER_OF_KEY_URI = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
    public static final String SAML2_SENDER_VOUCHES_URI = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    public static final String SAML11_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
    public static final String SAML11_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    public static final String SAML2_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    public static final String SAML2_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";

    public static Element toElement(AssertionType assertion) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SAMLAssertionWriter writer = new SAMLAssertionWriter(StaxUtil.getXMLStreamWriter(baos));
        writer.write(assertion);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        Document document = DocumentUtil.getDocument(bis);
        if (trace) {
            log.trace((Object)("Written Assertion=" + DocumentUtil.asString(document)));
        }
        return document.getDocumentElement();
    }

    public static Element toElement(SAML11AssertionType assertion) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SAML11AssertionWriter writer = new SAML11AssertionWriter(StaxUtil.getXMLStreamWriter(baos));
        writer.write(assertion);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        Document document = DocumentUtil.getDocument(bis);
        return document.getDocumentElement();
    }

    public static AssertionType fromElement(Element assertionElement) throws ProcessingException, ConfigurationException, ParsingException {
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(assertionElement);
        AssertionType assertion = (AssertionType)samlParser.parse(DocumentUtil.getNodeAsStream(assertionElement));
        return assertion;
    }

    public static SAML11AssertionType saml11FromElement(Element assertionElement) throws GeneralSecurityException {
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(assertionElement);
        return (SAML11AssertionType)samlParser.parse(DocumentUtil.getNodeAsStream(assertionElement));
    }
}

