/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.factories;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext createSecurityContext() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)"CLIENT");
            }
        });
    }

    static MBeanServer getJBossMBeanServer() {
        return AccessController.doPrivileged(new PrivilegedAction<MBeanServer>(){

            @Override
            public MBeanServer run() {
                MBeanServer cached = null;
                for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
                    String defaultDomain = server.getDefaultDomain();
                    if (defaultDomain == null) continue;
                    if (defaultDomain.contains("Default")) {
                        cached = server;
                    }
                    if (!defaultDomain.equals("jboss")) continue;
                    return server;
                }
                if (cached != null) {
                    return cached;
                }
                throw new IllegalStateException("PL00092: Null Value:No 'jboss' MBeanServer found!");
            }
        });
    }
}

