/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.pdp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedActionException;
import javax.annotation.Resource;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.apache.log4j.Logger;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.picketlink.identity.federation.core.pdp.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SOAPSAMLXACMLUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLResponseWriter;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.SystemPropertiesUtil;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(serviceName="SOAPSAMLXACMLPDP", portName="SOAPSAMLXACMLPort", targetNamespace="urn:picketlink:identity-federation:pdp", wsdlLocation="WEB-INF/wsdl/SOAPSAMLXACMLPDP.wsdl")
public class SOAPSAMLXACMLPDP
implements Provider<Source> {
    protected Logger log = Logger.getLogger(SOAPSAMLXACMLPDP.class);
    @Resource
    protected WebServiceContext context;
    protected String policyConfigFileName = "policyConfig.xml";
    protected PolicyDecisionPoint pdp;
    protected String issuer = "PicketLinkPDP";

    public SOAPSAMLXACMLPDP() {
        try {
            this.pdp = this.getPDP();
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public Source invoke(Source request) {
        try {
            Document doc = (Document)DocumentUtil.getNodeFromSource(request);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received Message::" + DocumentUtil.asString(doc)));
            }
            XACMLAuthzDecisionQueryType xacmlQuery = SOAPSAMLXACMLUtil.getXACMLQueryType(doc);
            ResponseType samlResponseType = SOAPSAMLXACMLUtil.handleXACMLQuery(this.pdp, this.issuer, xacmlQuery);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter xmlStreamWriter = StaxUtil.getXMLStreamWriter(baos);
            SAMLResponseWriter samlResponseWriter = new SAMLResponseWriter(xmlStreamWriter);
            samlResponseWriter.write(samlResponseType);
            Document responseDocument = DocumentUtil.getDocument(new ByteArrayInputStream(baos.toByteArray()));
            return new DOMSource(responseDocument.getDocumentElement());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PolicyDecisionPoint getPDP() throws PrivilegedActionException {
        InputStream is;
        SystemPropertiesUtil.ensure();
        URL url = SecurityActions.loadResource(this.getClass(), this.policyConfigFileName);
        if (url == null) {
            throw new IllegalStateException("PL00075: File could not be located :" + this.policyConfigFileName);
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new JBossPDP(is);
    }
}

