/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.io.ByteArrayOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamResult;
import org.jboss.security.xacml.core.model.context.ObjectFactory;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResponseType;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.TransformerUtil;
import org.w3c.dom.Document;

public class SAMLXACMLUtil {
    public static final String XACML_PKG_PATH = "org.jboss.security.xacml.core.model.context";

    public static JAXBContext getJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)XACML_PKG_PATH);
    }

    public static Document getXACMLResponse(ResponseType responseType) throws ProcessingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXBElement jaxb = new ObjectFactory().createResponse(responseType);
        StreamResult result = new StreamResult(baos);
        try {
            TransformerUtil.transform(SAMLXACMLUtil.getJAXBContext(), jaxb, result);
            return DocumentUtil.getDocument(new String(baos.toByteArray()));
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    public static Document getXACMLRequest(RequestType requestType) throws ProcessingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXBElement jaxb = new ObjectFactory().createRequest(requestType);
        StreamResult result = new StreamResult(baos);
        try {
            TransformerUtil.transform(SAMLXACMLUtil.getJAXBContext(), jaxb, result);
            return DocumentUtil.getDocument(new String(baos.toByteArray()));
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }
}

