/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts;

import java.util.Map;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.SecurityActions;
import org.picketlink.identity.federation.core.sts.registry.DefaultRevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.DefaultTokenRegistry;
import org.picketlink.identity.federation.core.sts.registry.FileBasedRevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.FileBasedTokenRegistry;
import org.picketlink.identity.federation.core.sts.registry.JPABasedRevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.RevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.SecurityTokenRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecurityTokenProvider
implements SecurityTokenProvider {
    protected static Logger logger = Logger.getLogger(AbstractSecurityTokenProvider.class);
    protected static final String TOKEN_REGISTRY = "TokenRegistry";
    protected static final String TOKEN_REGISTRY_FILE = "TokenRegistryFile";
    protected static final String REVOCATION_REGISTRY = "RevocationRegistry";
    protected static final String REVOCATION_REGISTRY_FILE = "RevocationRegistryFile";
    protected static final String REVOCATION_REGISTRY_JPA_CONFIG = "RevocationRegistryJPAConfig";
    protected static final String ATTRIBUTE_PROVIDER = "AttributeProvider";
    protected SecurityTokenRegistry tokenRegistry = new DefaultTokenRegistry();
    protected RevocationRegistry revocationRegistry = new DefaultRevocationRegistry();
    protected Map<String, String> properties;

    @Override
    public void initialize(Map<String, String> properties) {
        String registryOption;
        this.properties = properties;
        String tokenRegistryOption = this.properties.get(TOKEN_REGISTRY);
        if (tokenRegistryOption == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Security Token registry option not specified: Issued Tokens will not be persisted!");
            }
        } else if ("FILE".equalsIgnoreCase(tokenRegistryOption)) {
            String tokenRegistryFile = this.properties.get(TOKEN_REGISTRY_FILE);
            this.tokenRegistry = tokenRegistryFile != null ? new FileBasedTokenRegistry(tokenRegistryFile) : new FileBasedTokenRegistry();
        } else {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), tokenRegistryOption);
                if (clazz != null) {
                    Object object = clazz.newInstance();
                    if (object instanceof RevocationRegistry) {
                        this.tokenRegistry = (SecurityTokenRegistry)object;
                    } else {
                        logger.warn((Object)(String.valueOf(tokenRegistryOption) + " is not an instance of SecurityTokenRegistry - using default registry"));
                    }
                }
            }
            catch (Exception pae) {
                logger.warn((Object)"Error instantiating revocation registry class - using default registry");
                pae.printStackTrace();
            }
        }
        if (this.tokenRegistry == null) {
            this.tokenRegistry = new DefaultTokenRegistry();
        }
        if ((registryOption = this.properties.get(REVOCATION_REGISTRY)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Revocation registry option not specified: cancelled ids will not be persisted!");
            }
        } else if ("FILE".equalsIgnoreCase(registryOption)) {
            String registryFile = this.properties.get(REVOCATION_REGISTRY_FILE);
            this.revocationRegistry = registryFile != null ? new FileBasedRevocationRegistry(registryFile) : new FileBasedRevocationRegistry();
        } else if ("JPA".equalsIgnoreCase(registryOption)) {
            String configuration = this.properties.get(REVOCATION_REGISTRY_JPA_CONFIG);
            this.revocationRegistry = configuration != null ? new JPABasedRevocationRegistry(configuration) : new JPABasedRevocationRegistry();
        } else {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), registryOption);
                if (clazz != null) {
                    Object object = clazz.newInstance();
                    if (object instanceof RevocationRegistry) {
                        this.revocationRegistry = (RevocationRegistry)object;
                    } else {
                        logger.warn((Object)(String.valueOf(registryOption) + " is not an instance of RevocationRegistry - using default registry"));
                    }
                }
            }
            catch (Exception pae) {
                logger.warn((Object)"Error instantiating revocation registry class - using default registry");
                pae.printStackTrace();
            }
        }
        if (this.revocationRegistry == null) {
            this.revocationRegistry = new DefaultRevocationRegistry();
        }
    }
}

