/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.wstrust.SecurityActions;

public class STSClientConfig {
    protected static Logger log = Logger.getLogger(STSClientConfig.class);
    protected static boolean trace = log.isTraceEnabled();
    public static final String DEFAULT_CONFIG_FILE = "sts-client.properties";
    public static final String SERVICE_NAME = "serviceName";
    public static final String PORT_NAME = "portName";
    public static final String ENDPOINT_ADDRESS = "endpointAddress";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String TOKEN_TYPE = "tokenType";
    public static final String WSA_ISSUER = "wsaIssuer";
    public static final String WSP_APPLIES_TO = "wspAppliesTo";
    public static final String IS_BATCH = "isBatch";
    private final String serviceName;
    private final String portName;
    private final String endpointAddress;
    private final String username;
    private final String password;
    private final String wsaIssuer;
    private final String wspAppliesTo;
    private boolean isBatch = false;

    private STSClientConfig(Builder builder) {
        this.serviceName = builder.serviceName;
        this.portName = builder.portName;
        this.endpointAddress = builder.endpointAddress;
        this.username = builder.username;
        this.password = builder.password;
        this.isBatch = builder.isBatch;
        this.wsaIssuer = builder.wsaIssuer;
        this.wspAppliesTo = builder.wspAppliesTo;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getEndPointAddress() {
        return this.endpointAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getWsaIssuer() {
        return this.wsaIssuer;
    }

    public String getWspAppliesTo() {
        return this.wspAppliesTo;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[serviceName=" + this.serviceName + ", portName=" + this.portName + ", endpointAddress=" + this.endpointAddress + "]";
    }

    private static InputStream getResource(String resource) throws IOException {
        InputStream is;
        File file = new File(resource);
        if (file.exists() && !file.isDirectory()) {
            return new FileInputStream(file);
        }
        URL url = SecurityActions.loadResource(STSClientConfig.class, resource);
        if (url != null && (is = url.openStream()) != null) {
            return is;
        }
        return null;
    }

    /* synthetic */ STSClientConfig(Builder builder, STSClientConfig sTSClientConfig) {
        this(builder);
    }

    public static class Builder {
        private String serviceName;
        private String portName;
        private String endpointAddress;
        private String username;
        private String password;
        private String wsaIssuer;
        private String wspAppliesTo;
        private boolean isBatch;

        public Builder() {
        }

        public Builder(String configFile) {
            this.populate(configFile);
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public Builder endpointAddress(String address) {
            this.endpointAddress = address;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder wsaIssuer(String wsa) {
            this.wsaIssuer = wsa;
            return this;
        }

        public Builder wspAppliesTo(String wsp) {
            this.wspAppliesTo = wsp;
            return this;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getPortName() {
            return this.portName;
        }

        public String getEndpointAddress() {
            return this.endpointAddress;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isBatch() {
            return this.isBatch;
        }

        public void setBatch(boolean isBatch) {
            this.isBatch = isBatch;
        }

        public STSClientConfig build() {
            this.validate(this);
            return new STSClientConfig(this, null);
        }

        private void populate(String configFile) {
            block13: {
                InputStream in = null;
                try {
                    try {
                        in = STSClientConfig.getResource(configFile);
                        if (in == null) {
                            throw new IllegalStateException("PL00092: Null Value:properties file " + configFile);
                        }
                        Properties properties = new Properties();
                        properties.load(in);
                        this.serviceName = properties.getProperty(STSClientConfig.SERVICE_NAME);
                        this.portName = properties.getProperty(STSClientConfig.PORT_NAME);
                        this.endpointAddress = properties.getProperty(STSClientConfig.ENDPOINT_ADDRESS);
                        this.username = properties.getProperty(STSClientConfig.USERNAME);
                        this.password = properties.getProperty(STSClientConfig.PASSWORD);
                        this.wsaIssuer = properties.getProperty(STSClientConfig.WSA_ISSUER);
                        this.wspAppliesTo = properties.getProperty(STSClientConfig.WSP_APPLIES_TO);
                        String batchStr = properties.getProperty(STSClientConfig.IS_BATCH);
                        boolean bl = this.isBatch = StringUtil.isNotNull(batchStr) ? Boolean.parseBoolean(batchStr) : false;
                        if (!this.password.startsWith("MASK-")) break block13;
                        String salt = properties.getProperty("salt");
                        int iterationCount = Integer.parseInt(properties.getProperty("iterationCount"));
                        try {
                            this.password = StringUtil.decode(this.password, salt, iterationCount);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("PL00102: Processing Exception:Unable to decode password:" + this.password);
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("PL00102: Processing Exception:Could not load properties from " + configFile);
                    }
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ignored) {
                        ignored.printStackTrace();
                    }
                }
            }
        }

        private void validate(Builder builder) {
            if (trace) {
                log.trace((Object)"Checkin ServiceName:");
            }
            this.checkPropertyShowValue(this.serviceName, STSClientConfig.SERVICE_NAME);
            if (trace) {
                log.trace((Object)"Checkin portName:");
            }
            this.checkPropertyShowValue(this.portName, STSClientConfig.PORT_NAME);
            if (trace) {
                log.trace((Object)"Checkin endpointAddress:");
            }
            this.checkPropertyShowValue(this.endpointAddress, this.endpointAddress);
            if (trace) {
                log.trace((Object)"Checkin username:");
            }
            this.checkProperty(this.username, STSClientConfig.USERNAME);
            if (trace) {
                log.trace((Object)"password portName:");
            }
            this.checkProperty(this.password, STSClientConfig.PASSWORD);
        }

        private void checkPropertyShowValue(String propertyName, String propertyValue) {
            if (propertyValue == null || propertyValue.equals("")) {
                throw new IllegalArgumentException("PL00092: Null Value:" + propertyName + " : was:" + propertyValue);
            }
        }

        private void checkProperty(String propertyName, String propertyValue) {
            if (propertyValue == null || propertyValue.equals("")) {
                throw new IllegalArgumentException("PL00092: Null Value:" + propertyValue);
            }
        }
    }
}

