/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;

public class SAML2InResponseToVerificationHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2InResponseToVerificationHandler.class);
    private final boolean trace = log.isTraceEnabled();

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            return;
        }
        String authnRequestId = (String)request.getOptions().get("AUTH_REQUEST_ID");
        HttpSession session = BaseSAML2Handler.getHttpSession(request);
        session.setAttribute("AUTH_REQUEST_ID", (Object)authnRequestId);
        if (this.trace) {
            log.trace((Object)("ID of authentication request " + authnRequestId + " saved into HTTP session."));
        }
    }

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            return;
        }
        ResponseType responseType = (ResponseType)request.getSAML2Object();
        String inResponseTo = responseType.getInResponseTo();
        HttpSession session = BaseSAML2Handler.getHttpSession(request);
        String authnRequestId = (String)session.getAttribute("AUTH_REQUEST_ID");
        session.removeAttribute("AUTH_REQUEST_ID");
        if (inResponseTo != null && inResponseTo.equals(authnRequestId)) {
            if (this.trace) {
                log.trace((Object)("Successful verification of InResponseTo for request " + inResponseTo));
            }
        } else {
            log.error((Object)("Verification of InResponseTo failed. InResponseTo from SAML response is " + inResponseTo + ". Value of request Id from HTTP session is " + authnRequestId));
            throw new ProcessingException("PL00104:Authn Request ID verification failed:");
        }
    }
}

