/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.factories;

import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.factories.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;

public class SAML2HandlerChainFactory {
    public static SAML2HandlerChain createChain() {
        return new DefaultSAML2HandlerChain();
    }

    public static SAML2HandlerChain createChain(String fqn) throws ProcessingException {
        if (fqn == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:fqn");
        }
        Class<?> clazz = SecurityActions.loadClass(SAML2HandlerChainFactory.class, fqn);
        if (clazz == null) {
            throw new ProcessingException("PL00085: Class Not Loaded:" + fqn);
        }
        try {
            return (SAML2HandlerChain)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ProcessingException("PL00086: Cannot create instance of:" + fqn, e);
        }
    }
}

