/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.X500SAMLProfileConstants;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextClassRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementUtil {
    public static final QName X500_QNAME = new QName(JBossSAMLURIConstants.X500_NSURI.get(), "Encoding", JBossSAMLURIConstants.X500_PREFIX.get());

    public static AuthnStatementType createAuthnStatement(XMLGregorianCalendar instant, String authnContextClassRefValue) {
        AuthnStatementType authnStatement = new AuthnStatementType(instant);
        AuthnContextType authnContext = new AuthnContextType();
        AuthnContextClassRefType authnContextClassRef = new AuthnContextClassRefType(URI.create(authnContextClassRefValue));
        AuthnContextType.AuthnContextTypeSequence sequence = authnContext.new AuthnContextType.AuthnContextTypeSequence();
        sequence.setClassRef(authnContextClassRef);
        authnContext.setSequence(sequence);
        authnStatement.setAuthnContext(authnContext);
        return authnStatement;
    }

    public static AttributeStatementType createAttributeStatement(Map<String, Object> attributes) {
        AttributeStatementType attrStatement = null;
        int i = 0;
        Set<String> keys = attributes.keySet();
        for (String key : keys) {
            AttributeType att;
            if (i == 0) {
                attrStatement = new AttributeStatementType();
                ++i;
            }
            if ("roles".equalsIgnoreCase(key)) {
                Object value = attributes.get(key);
                if (!(value instanceof Collection)) continue;
                Collection roles = (Collection)value;
                for (Object role : roles) {
                    AttributeType roleAttr = new AttributeType("Role");
                    roleAttr.addAttributeValue(role);
                    attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(roleAttr));
                }
                continue;
            }
            Object value = attributes.get(key);
            String uri = X500SAMLProfileConstants.getOID(key);
            if (StringUtil.isNotNull(uri)) {
                att = StatementUtil.getX500Attribute(uri);
                att.setFriendlyName(key);
            } else {
                att = new AttributeType(key);
                att.setFriendlyName(key);
                att.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get());
            }
            att.addAttributeValue(value);
            attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(att));
        }
        return attrStatement;
    }

    public static AttributeStatementType createAttributeStatement(List<String> roles) {
        AttributeStatementType attrStatement = new AttributeStatementType();
        for (String role : roles) {
            AttributeType attr = new AttributeType("Role");
            attr.addAttributeValue(role);
            attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
        }
        return attrStatement;
    }

    public static AttributeStatementType createAttributeStatement(String key, String value) {
        AttributeStatementType attrStatement = new AttributeStatementType();
        AttributeType attr = new AttributeType(key);
        attr.addAttributeValue(value);
        attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
        return attrStatement;
    }

    private static AttributeType getX500Attribute(String name) {
        AttributeType att = new AttributeType(name);
        att.getOtherAttributes().put(X500_QNAME, "LDAP");
        att.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get());
        return att;
    }
}

