/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.jpa.schema;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.jpa.schema.internal.JPATemplate;
import org.picketlink.idm.jpa.schema.internal.SimpleJPAIdentityStore;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractJPAIdentityManagerTestCase {
    protected static EntityManagerFactory emf;
    protected EntityManager entityManager;
    private DefaultIdentityManager identityManager;

    @BeforeClass
    public static void onBeforeTests() throws Exception {
        emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
    }

    @AfterClass
    public static void onAfterTests() throws Exception {
        emf.close();
    }

    @Before
    public void onSetupTest() throws Exception {
        this.entityManager = emf.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    @After
    public void onFinishTest() throws Exception {
        this.entityManager.flush();
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
    }

    protected IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = new DefaultIdentityManager();
            this.identityManager.setIdentityStore(this.createIdentityStore());
        }
        return this.identityManager;
    }

    protected IdentityStore createIdentityStore() {
        SimpleJPAIdentityStore identityStore = new SimpleJPAIdentityStore();
        JPATemplate jpaTemplate = new JPATemplate();
        jpaTemplate.setEntityManager(this.entityManager);
        identityStore.setJpaTemplate(jpaTemplate);
        return identityStore;
    }
}

