/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.jpa.schema;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.jpa.schema.DatabaseUser;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.jpa.schema.AbstractJPAIdentityManagerTestCase;

public class JPAMembershipQueryTestCase
extends AbstractJPAIdentityManagerTestCase {
    private static final String USER_NAME = "theuser";
    private static final String GROUP_NAME = "Administrators";
    private static final String ROLE_NAME = "admin";
    private Group group;
    private User user;
    private Role role;
    private Membership membership;

    @Override
    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadMemberships();
    }

    @Test
    public void testfindByGroup() throws Exception {
        MembershipQuery query = this.createMembershipQuery();
        query.setGroup(this.group);
        this.assertQueryResult(query);
        query.setGroup("67676");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByRole() throws Exception {
        MembershipQuery query = this.createMembershipQuery();
        query.setRole(this.role);
        this.assertQueryResult(query);
        query.setRole("12121");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByUser() throws Exception {
        MembershipQuery query = this.createMembershipQuery();
        query.setUser(this.user);
        this.assertQueryResult(query);
        query.setUser("12121");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    private void loadMemberships() {
        IdentityStore identityManager = this.createIdentityStore();
        this.group = identityManager.getGroup(null, GROUP_NAME);
        this.role = identityManager.getRole(null, ROLE_NAME);
        this.user = identityManager.getUser(null, USER_NAME);
        this.membership = identityManager.getMembership(null, (IdentityType)this.user, this.group, this.role);
        if (this.membership != null) {
            return;
        }
        this.group = identityManager.createGroup(null, GROUP_NAME, null);
        this.user = new DatabaseUser(USER_NAME);
        identityManager.createUser(null, this.user);
        this.role = identityManager.createRole(null, ROLE_NAME);
        this.membership = identityManager.createMembership(null, (IdentityType)this.user, this.group, this.role);
    }

    private void assertQueryResult(MembershipQuery query) {
        IdentityStore identityStore = this.createIdentityStore();
        List result = identityStore.executeQuery(null, query, null);
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)this.role.getName(), (String)((Membership)result.get(0)).getRole().getName());
        junit.framework.Assert.assertEquals((String)this.group.getId(), (String)((Membership)result.get(0)).getGroup().getId());
        junit.framework.Assert.assertEquals((String)this.user.getId(), (String)((User)((Membership)result.get(0)).getMember()).getId());
    }

    private MembershipQuery createMembershipQuery() {
        return this.getIdentityManager().createMembershipQuery();
    }
}

