/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.schema;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.picketlink.idm.jpa.schema.AbstractDatabaseIdentityType;
import org.picketlink.idm.jpa.schema.DatabaseMembership;
import org.picketlink.idm.jpa.schema.DatabaseRoleAttribute;
import org.picketlink.idm.model.Role;

@Entity
@NamedQuery(name="ROLE.LOAD_BY_KEY", query="from DatabaseRole where name = :name")
public class DatabaseRole
extends AbstractDatabaseIdentityType<DatabaseRoleAttribute>
implements Role {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long internalId;
    private String name;
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL})
    private List<DatabaseRoleAttribute> ownerAttributes = new ArrayList<DatabaseRoleAttribute>();
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL})
    private List<DatabaseMembership> memberships = new ArrayList<DatabaseMembership>();

    public DatabaseRole() {
    }

    public DatabaseRole(String name) {
        super(name);
        this.setName(name);
    }

    public long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<DatabaseRoleAttribute> getOwnerAttributes() {
        return this.ownerAttributes;
    }

    public void setOwnerAttributes(List<DatabaseRoleAttribute> ownerAttributes) {
        this.ownerAttributes = ownerAttributes;
    }

    public List<DatabaseMembership> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(List<DatabaseMembership> memberships) {
        this.memberships = memberships;
    }

    @Override
    protected DatabaseRoleAttribute createAttribute(String name, String value) {
        return new DatabaseRoleAttribute(name, value);
    }

    @Override
    public String getKey() {
        return String.format("%s%s", "ROLE://", this.name);
    }
}

