/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.schema;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import org.picketlink.idm.jpa.schema.AbstractDatabaseIdentityType;
import org.picketlink.idm.jpa.schema.DatabaseGroupAttribute;
import org.picketlink.idm.jpa.schema.DatabaseMembership;
import org.picketlink.idm.model.Group;

@Entity
@NamedQuery(name="GROUP.LOAD_BY_KEY", query="from DatabaseGroup where name = :name")
public class DatabaseGroup
extends AbstractDatabaseIdentityType<DatabaseGroupAttribute>
implements Group {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long internalId;
    private String name;
    @ManyToOne
    private DatabaseGroup parentGroup;
    @OneToMany(mappedBy="group", cascade={CascadeType.ALL})
    private List<DatabaseGroupAttribute> ownerAttributes = new ArrayList<DatabaseGroupAttribute>();
    @OneToMany(mappedBy="group", cascade={CascadeType.ALL})
    private List<DatabaseMembership> memberships = new ArrayList<DatabaseMembership>();

    public DatabaseGroup() {
    }

    public DatabaseGroup(String name) {
        super(name);
        this.setName(name);
    }

    public long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(DatabaseGroup parentGroup) {
        this.parentGroup = parentGroup;
    }

    public void setOwnerAttributes(List<DatabaseGroupAttribute> ownerAttributes) {
        this.ownerAttributes = ownerAttributes;
    }

    public List<DatabaseMembership> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(List<DatabaseMembership> memberships) {
        this.memberships = memberships;
    }

    @Override
    public List<DatabaseGroupAttribute> getOwnerAttributes() {
        return this.ownerAttributes;
    }

    @Override
    protected DatabaseGroupAttribute createAttribute(String name, String value) {
        return new DatabaseGroupAttribute(name, value);
    }

    @Override
    public String getKey() {
        return String.format("%s%s", "GROUP://", this.name);
    }
}

