/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.basic.AbstractIdentityTypeTestCase;
import org.picketlink.test.idm.suites.LDAPIdentityStoreWithoutAttributesTestSuite;

public class UserManagementTestCase
extends AbstractIdentityTypeTestCase<User> {
    @Test
    public void testCreate() throws Exception {
        User newUser = this.createUser("jduke");
        Assert.assertNotNull((Object)newUser.getId());
        newUser.setEmail("jduke@jboss.org");
        newUser.setFirstName("Java");
        newUser.setLastName("Duke");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)newUser);
        User storedUser = identityManager.getUser(newUser.getLoginName());
        Assert.assertNotNull((Object)storedUser);
        junit.framework.Assert.assertEquals((String)newUser.getId(), (String)storedUser.getId());
        junit.framework.Assert.assertEquals((String)newUser.getLoginName(), (String)storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)newUser.getFirstName(), (String)storedUser.getFirstName());
        junit.framework.Assert.assertEquals((String)newUser.getLastName(), (String)storedUser.getLastName());
        junit.framework.Assert.assertEquals((String)newUser.getEmail(), (String)storedUser.getEmail());
        Assert.assertNotNull((Object)storedUser.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedUser.getPartition().getId());
        junit.framework.Assert.assertTrue((boolean)storedUser.isEnabled());
        junit.framework.Assert.assertNull((Object)storedUser.getExpirationDate());
        Assert.assertNotNull((Object)storedUser.getCreatedDate());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedUser.getCreatedDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testUpdate() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User storedUser = this.createUser("admin");
        storedUser.setEmail("admin@jboss.org");
        storedUser.setFirstName("The");
        storedUser.setLastName("Administrator");
        identityManager.update((IdentityType)storedUser);
        storedUser = identityManager.getUser(storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)"admin", (String)storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)"The", (String)storedUser.getFirstName());
        junit.framework.Assert.assertEquals((String)"Administrator", (String)storedUser.getLastName());
        junit.framework.Assert.assertEquals((String)"admin@jboss.org", (String)storedUser.getEmail());
        storedUser.setFirstName("Updated " + storedUser.getFirstName());
        storedUser.setLastName("Updated " + storedUser.getLastName());
        storedUser.setEmail("Updated " + storedUser.getEmail());
        Date actualDate = Calendar.getInstance().getTime();
        storedUser.setExpirationDate(actualDate);
        identityManager.update((IdentityType)storedUser);
        User updatedUser = identityManager.getUser(storedUser.getLoginName());
        junit.framework.Assert.assertEquals((String)"Updated The", (String)updatedUser.getFirstName());
        junit.framework.Assert.assertEquals((String)"Updated Administrator", (String)updatedUser.getLastName());
        junit.framework.Assert.assertEquals((String)"Updated admin@jboss.org", (String)updatedUser.getEmail());
        junit.framework.Assert.assertEquals((Object)actualDate, (Object)updatedUser.getExpirationDate());
    }

    @Test
    public void testRemove() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User someUser = this.createUser("admin");
        User anotherUser = this.createUser("someAnotherUser");
        identityManager.remove((IdentityType)someUser);
        User removedUser = this.getIdentityManager().getUser(someUser.getLoginName());
        junit.framework.Assert.assertNull((Object)removedUser);
        anotherUser = identityManager.getUser(anotherUser.getLoginName());
        Assert.assertNotNull((Object)anotherUser);
        Role role = this.createRole("role");
        Group group = this.createGroup("group", null);
        identityManager.grantRole((IdentityType)anotherUser, role);
        identityManager.addToGroup((Agent)anotherUser, group);
        identityManager.grantGroupRole((IdentityType)anotherUser, role, group);
        RelationshipQuery relationshipQuery = identityManager.createRelationshipQuery(Grant.class);
        relationshipQuery.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{anotherUser});
        Assert.assertFalse((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupMembership.class);
        relationshipQuery.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{anotherUser});
        Assert.assertFalse((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupRole.class);
        relationshipQuery.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{anotherUser});
        Assert.assertFalse((boolean)relationshipQuery.getResultList().isEmpty());
        identityManager.remove((IdentityType)anotherUser);
        relationshipQuery = identityManager.createRelationshipQuery(Grant.class);
        relationshipQuery.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{anotherUser});
        junit.framework.Assert.assertTrue((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupMembership.class);
        relationshipQuery.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{anotherUser});
        junit.framework.Assert.assertTrue((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupRole.class);
        relationshipQuery.setParameter((QueryParameter)GroupRole.ASSIGNEE, new Object[]{anotherUser});
        junit.framework.Assert.assertTrue((boolean)relationshipQuery.getResultList().isEmpty());
    }

    @Test
    public void testEqualsMethod() {
        User instanceA = this.createUser("userA");
        User instanceB = this.createUser("userB");
        Assert.assertFalse((boolean)instanceA.equals(instanceB));
        IdentityManager identityManager = this.getIdentityManager();
        junit.framework.Assert.assertTrue((boolean)instanceA.equals(identityManager.getUser(instanceA.getLoginName())));
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testSetCertificateAsAttribute() {
        User mary = this.createUser("mary");
        IdentityManager identityManager = this.getIdentityManager();
        X509Certificate certificate = this.getTestingCertificate("servercert.txt");
        mary.setAttribute(new Attribute("certificate", (Serializable)certificate));
        identityManager.update((IdentityType)mary);
        mary = identityManager.getUser(mary.getLoginName());
        Assert.assertNotNull((Object)mary.getAttribute("certificate"));
        junit.framework.Assert.assertEquals((Object)certificate, (Object)mary.getAttribute("certificate").getValue());
    }

    @Override
    protected User createIdentityType() {
        return this.createUser("admin");
    }

    @Override
    protected User getIdentityType() {
        return this.getIdentityManager().getUser("admin");
    }

    private X509Certificate getTestingCertificate(String fromTextFile) {
        InputStream bis = this.getClass().getClassLoader().getResourceAsStream("cert/" + fromTextFile);
        X509Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(bis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load testing certificate.", e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
        return cert;
    }
}

