/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.test.idm.config.AbstractFeaturesSetConfigurationTestCase;

public class LDAPIdentityStoreConfigurationTestCase
extends AbstractFeaturesSetConfigurationTestCase<LDAPStoreConfigurationBuilder> {
    private static final String BASE_DN = "dc=jboss,dc=org";
    private static final String LDAP_URL = "ldap://localhost:10389";
    private static final String ROLES_DN_SUFFIX = "ou=Roles,dc=jboss,dc=org";
    private static final String GROUP_DN_SUFFIX = "ou=Groups,dc=jboss,dc=org";
    private static final String USER_DN_SUFFIX = "ou=People,dc=jboss,dc=org";
    private static final String AGENT_DN_SUFFIX = "ou=Agent,dc=jboss,dc=org";
    private static AbstractLDAPTest instance;

    @BeforeClass
    public static void onBeforeClass() {
        try {
            instance = new AbstractLDAPTest(){

                @Before
                public void setup() throws Exception {
                    super.setup();
                    this.importLDIF("ldap/users.ldif");
                }
            };
            instance.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void onDestroyClass() {
        try {
            instance.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Test
    public void failFeatureNotSupportedCustomRelationship() {
    }

    @Override
    protected LDAPStoreConfigurationBuilder createMinimalConfiguration(IdentityConfigurationBuilder builder) {
        LDAPStoreConfigurationBuilder storeConfig = (LDAPStoreConfigurationBuilder)builder.stores().ldap().baseDN(BASE_DN).bindDN("uid=admin,ou=system").bindCredential("secret").url(LDAP_URL).userDNSuffix(USER_DN_SUFFIX).roleDNSuffix(ROLES_DN_SUFFIX).agentDNSuffix(AGENT_DN_SUFFIX).groupDNSuffix(GROUP_DN_SUFFIX).addGroupMapping("/QA Group", "ou=QA,dc=jboss,dc=org").supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.attribute, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureGroup.credential});
        return storeConfig;
    }

    @Override
    protected IdentityManager createIdentityManager(IdentityConfiguration config) {
        IdentityManagerFactory factory = new IdentityManagerFactory(config);
        return factory.createIdentityManager();
    }
}

