/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.credential;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.X509CertificateCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class CertificateCredentialTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testSuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        X509Certificate clientCert = this.getTestingCertificate("servercert.txt");
        X509CertificateCredentials credential = new X509CertificateCredentials(clientCert);
        User user = this.createUser(credential.getUsername());
        identityManager.updateCredential((Agent)user, (Object)clientCert);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testUnsuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        X509Certificate clientCert = this.getTestingCertificate("servercert.txt");
        X509CertificateCredentials credential = new X509CertificateCredentials(clientCert);
        User user = this.createUser(credential.getUsername());
        identityManager.updateCredential((Agent)user, (Object)clientCert);
        X509Certificate badCert = this.getTestingCertificate("servercert2.txt");
        X509CertificateCredentials badCredential = new X509CertificateCredentials(badCert);
        badCredential.setUserName(user.getId());
        identityManager.validateCredentials((Credentials)badCredential);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badCredential.getStatus());
    }

    @Test
    public void testUserDisabled() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        X509Certificate clientCert = this.getTestingCertificate("servercert.txt");
        X509CertificateCredentials credential = new X509CertificateCredentials(clientCert);
        User user = this.createUser(credential.getUsername());
        identityManager.updateCredential((Agent)user, (Object)clientCert);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
        user.setEnabled(false);
        identityManager.update((IdentityType)user);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.AGENT_DISABLED, (Object)credential.getStatus());
    }

    private X509Certificate getTestingCertificate(String fromTextFile) {
        InputStream bis = this.getClass().getClassLoader().getResourceAsStream("cert/" + fromTextFile);
        X509Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(bis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load testing certificate.", e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
        return cert;
    }
}

