/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.credential;

import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreWithoutAttributesTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPUsersJPARolesGroupsFileRelationshipTestSuite;
import org.picketlink.test.idm.suites.LDAPUsersJPARolesGroupsRelationshipsTestSuite;

public class PasswordCredentialTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testSuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Password plainTextPassword = new Password("updated_password".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
        credential.setUsername(user.getLoginName());
        credential.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testUnsuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Password plainTextPassword = new Password("updated_password".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword, new Date(), null);
        UsernamePasswordCredentials badUserName = new UsernamePasswordCredentials();
        badUserName.setUsername("Bad" + user.getLoginName());
        badUserName.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)badUserName);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badUserName.getStatus());
        UsernamePasswordCredentials badPassword = new UsernamePasswordCredentials();
        plainTextPassword = new Password("bad_password".toCharArray());
        badPassword.setUsername(user.getLoginName());
        badPassword.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)badPassword);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badPassword.getStatus());
    }

    @Test
    public void testEmptyPasswordValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        String emptyPassword = null;
        Password plainTextPassword = new Password(emptyPassword);
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword, new Date(), null);
        UsernamePasswordCredentials badUserName = new UsernamePasswordCredentials();
        badUserName.setUsername("Bad" + user.getLoginName());
        badUserName.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)badUserName);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badUserName.getStatus());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class, LDAPUsersJPARolesGroupsRelationshipsTestSuite.class, LDAPUsersJPARolesGroupsFileRelationshipTestSuite.class})
    public void testExpiration() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Password plainTextPassword = new Password("updated_password".toCharArray());
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(12, -1);
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword, new Date(), expirationDate.getTime());
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
        credential.setUsername(user.getLoginName());
        credential.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.EXPIRED, (Object)credential.getStatus());
        Password newPassword = new Password("new_password".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)newPassword);
        credential = new UsernamePasswordCredentials(user.getLoginName(), newPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testUpdatePassword() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Password firstPassword = new Password("password1".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)firstPassword);
        UsernamePasswordCredentials firstCredential = new UsernamePasswordCredentials(user.getLoginName(), firstPassword);
        identityManager.validateCredentials((Credentials)firstCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)firstCredential.getStatus());
        Password secondPassword = new Password("password2".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)secondPassword);
        UsernamePasswordCredentials secondCredential = new UsernamePasswordCredentials(user.getLoginName(), secondPassword);
        identityManager.validateCredentials((Credentials)secondCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)secondCredential.getStatus());
        identityManager.validateCredentials((Credentials)firstCredential);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)firstCredential.getStatus());
    }

    @Test
    public void testUserDeletion() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User john = this.createUser("john");
        Password johnPassword = new Password("123".toCharArray());
        identityManager.updateCredential((Agent)john, (Object)johnPassword);
        UsernamePasswordCredentials johnCredential = new UsernamePasswordCredentials(john.getLoginName(), johnPassword);
        identityManager.validateCredentials((Credentials)johnCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)johnCredential.getStatus());
        User francesco = this.createUser("francesco");
        Password francescoPassword = new Password("123".toCharArray());
        identityManager.updateCredential((Agent)francesco, (Object)francescoPassword);
        UsernamePasswordCredentials francescoCredential = new UsernamePasswordCredentials(francesco.getLoginName(), francescoPassword);
        identityManager.validateCredentials((Credentials)francescoCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)francescoCredential.getStatus());
        identityManager.remove((IdentityType)francesco);
        identityManager.validateCredentials((Credentials)johnCredential);
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testUserDisabled() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Password plainTextPassword = new Password("updated_password".toCharArray());
        identityManager.updateCredential((Agent)user, (Object)plainTextPassword);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials();
        credential.setUsername(user.getLoginName());
        credential.setPassword(plainTextPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
        user.setEnabled(false);
        identityManager.update((IdentityType)user);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.AGENT_DISABLED, (Object)credential.getStatus());
    }
}

