/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.partition;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class RealmManagementTestCase
extends AbstractIdentityManagerTestCase {
    private static final String TESTING_REALM_NAME = "Testing";

    @Test
    public void testGetDefaultRealm() throws Exception {
        Realm defaultRealm = this.getIdentityManagerFactory().getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        Assert.assertEquals((Object)"default", (Object)defaultRealm.getId());
    }

    @Test(expected=SecurityConfigurationException.class)
    public void testUseNonExistentRealm() throws Exception {
        IdentityManager identityManager = this.getIdentityManagerFactory().createIdentityManager((Partition)new Realm("Not Configured Realm"));
        identityManager.add((IdentityType)new SimpleUser("mary"));
    }

    @Test
    public void testCreateUsers() throws Exception {
        Realm realm = this.getIdentityManagerFactory().getRealm(TESTING_REALM_NAME);
        User realmUser = this.createUser("realmUser", (Partition)realm);
        IdentityManager testingRealmManager = this.getIdentityManagerFactory().createIdentityManager((Partition)realm);
        realmUser = testingRealmManager.getUser(realmUser.getLoginName());
        Assert.assertNotNull((Object)realmUser);
        Assert.assertNotNull((Object)realmUser.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)realmUser.getPartition().getId());
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        realmUser = defaultIdentityManager.getUser(realmUser.getLoginName());
        Assert.assertNull((Object)realmUser);
    }

    @Test
    public void testCreateSameUserDifferentRealms() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleUser defaultRealmUser = new SimpleUser("commonName");
        defaultIdentityManager.add((IdentityType)defaultRealmUser);
        try {
            defaultIdentityManager.add((IdentityType)new SimpleUser(defaultRealmUser.getLoginName()));
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        defaultRealmUser = defaultIdentityManager.getUser(defaultRealmUser.getLoginName());
        Assert.assertNotNull((Object)defaultRealmUser);
        Realm realm = new Realm(TESTING_REALM_NAME);
        User testingRealmUser = this.createUser("commonName", (Partition)realm);
        IdentityManager testingRealmManager = this.getIdentityManagerFactory().createIdentityManager((Partition)realm);
        testingRealmUser = testingRealmManager.getUser(testingRealmUser.getLoginName());
        Assert.assertNotNull((Object)testingRealmUser);
        Assert.assertFalse((boolean)defaultRealmUser.getId().equals(testingRealmUser.getId()));
    }

    @Test
    public void testCreateSameRoleDifferentRealms() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleRole defaultRealmRole = new SimpleRole("commonName");
        defaultIdentityManager.add((IdentityType)defaultRealmRole);
        try {
            defaultIdentityManager.add((IdentityType)new SimpleRole(defaultRealmRole.getName()));
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        defaultRealmRole = defaultIdentityManager.getRole(defaultRealmRole.getName());
        Assert.assertNotNull((Object)defaultRealmRole);
        Realm realm = new Realm(TESTING_REALM_NAME);
        Role testingRealmRole = this.createRole("commonName", (Partition)realm);
        IdentityManager testingRealmManager = this.getIdentityManagerFactory().createIdentityManager((Partition)realm);
        testingRealmRole = testingRealmManager.getRole(testingRealmRole.getName());
        Assert.assertNotNull((Object)testingRealmRole);
        Assert.assertFalse((boolean)defaultRealmRole.getId().equals(testingRealmRole.getId()));
    }

    @Test
    public void testCreateSameGroupDifferentRealms() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleGroup defaultRealmGroup = new SimpleGroup("commonName");
        defaultIdentityManager.add((IdentityType)defaultRealmGroup);
        try {
            defaultIdentityManager.add((IdentityType)new SimpleGroup(defaultRealmGroup.getName()));
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        defaultRealmGroup = defaultIdentityManager.getGroup(defaultRealmGroup.getName());
        Assert.assertNotNull((Object)defaultRealmGroup);
        Realm realm = new Realm(TESTING_REALM_NAME);
        Group testingRealmGroup = this.createGroup("commonName", null, (Partition)realm);
        IdentityManager testingRealmManager = this.getIdentityManagerFactory().createIdentityManager((Partition)realm);
        testingRealmGroup = testingRealmManager.getGroup(testingRealmGroup.getName());
        Assert.assertNotNull((Object)testingRealmGroup);
        Assert.assertFalse((boolean)defaultRealmGroup.getId().equals(testingRealmGroup.getId()));
    }

    @Test
    public void testCreateRoles() throws Exception {
        Realm realm = new Realm(TESTING_REALM_NAME);
        Role testingRole = this.createRole("testingRole", (Partition)realm);
        testingRole = this.getIdentityManagerFactory().createIdentityManager((Partition)realm).getRole(testingRole.getName());
        Assert.assertNotNull((Object)testingRole);
        Assert.assertNotNull((Object)testingRole.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)testingRole.getPartition().getId());
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        testingRole = defaultIdentityManager.getRole(testingRole.getName());
        Assert.assertNull((Object)testingRole);
    }

    @Test
    public void testCreateGroups() throws Exception {
        Realm realm = new Realm(TESTING_REALM_NAME);
        Group testingGroup = this.createGroup("testingRealmGroup", null, (Partition)realm);
        testingGroup = this.getIdentityManagerFactory().createIdentityManager((Partition)realm).getGroup(testingGroup.getName());
        Assert.assertNotNull((Object)testingGroup);
        Assert.assertNotNull((Object)testingGroup.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)testingGroup.getPartition().getId());
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        testingGroup = defaultIdentityManager.getGroup(testingGroup.getName());
        Assert.assertNull((Object)testingGroup);
    }

    @Test
    public void testRelationships() throws Exception {
        SimpleUser defaultRealmUser = new SimpleUser("defaultRealmUser");
        SimpleRole defaultRealmRole = new SimpleRole("defaultRealmRole");
        SimpleGroup defaultRealmGroup = new SimpleGroup("defaultRealmGroup");
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        defaultIdentityManager.add((IdentityType)defaultRealmUser);
        defaultIdentityManager.add((IdentityType)defaultRealmRole);
        defaultIdentityManager.add((IdentityType)defaultRealmGroup);
        defaultIdentityManager.grantRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole);
        defaultIdentityManager.addToGroup((Agent)defaultRealmUser, (Group)defaultRealmGroup);
        defaultIdentityManager.grantGroupRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole, (Group)defaultRealmGroup);
        Assert.assertTrue((boolean)defaultIdentityManager.hasRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole));
        Assert.assertTrue((boolean)defaultIdentityManager.isMember((IdentityType)defaultRealmUser, (Group)defaultRealmGroup));
        Assert.assertTrue((boolean)defaultIdentityManager.hasGroupRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole, (Group)defaultRealmGroup));
        Realm realm = new Realm(TESTING_REALM_NAME);
        IdentityManager testingRealmManager = this.getIdentityManagerFactory().createIdentityManager((Partition)realm);
        Assert.assertFalse((boolean)testingRealmManager.hasRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole));
        Assert.assertFalse((boolean)testingRealmManager.isMember((IdentityType)defaultRealmUser, (Group)defaultRealmGroup));
        Assert.assertFalse((boolean)testingRealmManager.hasGroupRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole, (Group)defaultRealmGroup));
        User testingRealmUser = this.createUser("testingRealmUser", (Partition)realm);
        Role testingRealmRole = this.createRole("testingRealmRole", (Partition)realm);
        Group testingRealmGroup = this.createGroup("testingRealmGroup", null, (Partition)realm);
        testingRealmManager.grantRole((IdentityType)testingRealmUser, testingRealmRole);
        testingRealmManager.addToGroup((Agent)testingRealmUser, testingRealmGroup);
        testingRealmManager.grantGroupRole((IdentityType)testingRealmUser, testingRealmRole, testingRealmGroup);
        Assert.assertTrue((boolean)testingRealmManager.hasRole((IdentityType)testingRealmUser, testingRealmRole));
        Assert.assertTrue((boolean)testingRealmManager.isMember((IdentityType)testingRealmUser, testingRealmGroup));
        Assert.assertTrue((boolean)testingRealmManager.hasGroupRole((IdentityType)testingRealmUser, testingRealmRole, testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasRole((IdentityType)testingRealmUser, testingRealmRole));
        Assert.assertFalse((boolean)defaultIdentityManager.isMember((IdentityType)testingRealmUser, testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasGroupRole((IdentityType)testingRealmUser, testingRealmRole, testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasRole((IdentityType)defaultRealmUser, testingRealmRole));
        Assert.assertFalse((boolean)defaultIdentityManager.hasRole((IdentityType)testingRealmUser, (Role)defaultRealmRole));
        Assert.assertFalse((boolean)defaultIdentityManager.isMember((IdentityType)defaultRealmUser, testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.isMember((IdentityType)testingRealmUser, (Group)defaultRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasGroupRole((IdentityType)defaultRealmUser, testingRealmRole, (Group)defaultRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasGroupRole((IdentityType)testingRealmUser, (Role)defaultRealmRole, testingRealmGroup));
    }
}

