/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.partition;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class TierManagementTestCase
extends AbstractIdentityManagerTestCase {
    private static final String APPLICATION_TIER_NAME = "Application";

    @Test
    public void testCreateRoles() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        Tier applicationTier = new Tier(APPLICATION_TIER_NAME);
        IdentityManager applicationTierIdentityManager = this.getIdentityManagerFactory().createIdentityManager((Partition)applicationTier);
        Role testingRole = this.createRole("testingRole", (Partition)applicationTier);
        testingRole = applicationTierIdentityManager.getRole(testingRole.getName());
        Assert.assertNotNull((Object)testingRole);
        Assert.assertNotNull((Object)testingRole.getPartition());
        Assert.assertEquals((Object)applicationTier.getId(), (Object)testingRole.getPartition().getId());
        testingRole = defaultIdentityManager.getRole(testingRole.getName());
        Assert.assertNull((Object)testingRole);
    }

    @Test
    public void testGroupsForTier() throws Exception {
        Tier applicationTier = new Tier(APPLICATION_TIER_NAME);
        IdentityManager applicationTierIdentityManager = this.getIdentityManagerFactory().createIdentityManager((Partition)applicationTier);
        Group testingGroup = this.createGroup("testingGroupTier", null, (Partition)applicationTier);
        testingGroup = applicationTierIdentityManager.getGroup(testingGroup.getName());
        Assert.assertNotNull((Object)testingGroup);
        Assert.assertNotNull((Object)testingGroup.getPartition());
        Assert.assertEquals((Object)applicationTier.getId(), (Object)testingGroup.getPartition().getId());
        IdentityManager identityManager = this.getIdentityManager();
        testingGroup = identityManager.getGroup(testingGroup.getName());
        Assert.assertNull((Object)testingGroup);
    }

    @Test
    public void testRolesForTier() throws Exception {
        Tier applicationTier = new Tier(APPLICATION_TIER_NAME);
        IdentityManager applicationTierIdentityManager = this.getIdentityManagerFactory().createIdentityManager((Partition)applicationTier);
        Role testingRole = this.createRole("testingRoleTier", (Partition)applicationTier);
        testingRole = applicationTierIdentityManager.getRole(testingRole.getName());
        Assert.assertNotNull((Object)testingRole);
        Assert.assertNotNull((Object)testingRole.getPartition());
        Assert.assertEquals((Object)applicationTier.getId(), (Object)testingRole.getPartition().getId());
        IdentityManager identityManager = this.getIdentityManager();
        testingRole = identityManager.getRole(testingRole.getName());
        Assert.assertNull((Object)testingRole);
    }

    @Test
    public void failAddUserToTier() throws Exception {
        Tier applicationTier = new Tier(APPLICATION_TIER_NAME);
        try {
            this.createUser("testingUserTier", (Partition)applicationTier);
        }
        catch (IdentityManagementException ime) {
            Assert.assertTrue((boolean)ime.getMessage().contains("PLIDM000067"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

