/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.query.AgentQueryTestCase;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreWithoutAttributesTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPUsersJPARolesGroupsFileRelationshipTestSuite;
import org.picketlink.test.idm.suites.LDAPUsersJPARolesGroupsRelationshipsTestSuite;

public class UserQueryTestCase
extends AgentQueryTestCase<User> {
    @Override
    protected User createIdentityType(String name, Partition partition) {
        if (name == null) {
            name = "someUser";
        }
        return this.createUser(name, partition);
    }

    @Override
    protected User getIdentityType() {
        return this.getIdentityManager().getUser("someUser");
    }

    @Test
    public void testFindByFirstNameAndLastName() throws Exception {
        User admin = this.createUser("admin");
        admin.setFirstName("The");
        admin.setLastName("Administrator");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)admin);
        Assert.assertNotNull((Object)admin);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, admin.getId()));
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.LAST_NAME, new Object[]{"Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        query.setParameter(User.LAST_NAME, new Object[]{"Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)admin.getId(), (String)((User)result.get(0)).getId());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.FIRST_NAME, new Object[]{"The"});
        query.setParameter(User.LAST_NAME, new Object[]{"Bad Administrator"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindByEmail() throws Exception {
        User admin = this.createUser("admin");
        admin.setEmail("admin@jboss.org");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update((IdentityType)admin);
        IdentityQuery query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"admin@jboss.org"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)admin.getId(), (String)((User)result.get(0)).getId());
        query = identityManager.createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{"badadmin@jboss.org"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class, LDAPJPAMixedStoreTestSuite.class, LDAPUsersJPARolesGroupsRelationshipsTestSuite.class, LDAPUsersJPARolesGroupsFileRelationshipTestSuite.class})
    public void testFindWithPaginationAndSorting() throws Exception {
        this.createPopulatedUser("john", "John", "Anthony");
        IDMUtil.sleep((int)1);
        this.createPopulatedUser("root", "Root", "Root");
        IDMUtil.sleep((int)1);
        this.createPopulatedUser("mary", "Mary", "Kelly");
        IDMUtil.sleep((int)1);
        this.createPopulatedUser("demo", "Demo", "Demo");
        IDMUtil.sleep((int)1);
        this.createPopulatedUser("mary2", "Mary", "Anthony");
        IDMUtil.sleep((int)1);
        this.createPopulatedUser("john2", "John", "Kelly");
        IdentityQuery userQuery = this.getIdentityManager().createIdentityQuery(User.class);
        userQuery.setOffset(0);
        userQuery.setLimit(5);
        List users = userQuery.getResultList();
        junit.framework.Assert.assertEquals((int)5, (int)users.size());
        junit.framework.Assert.assertEquals((String)((User)users.get(0)).getLoginName(), (String)"demo");
        junit.framework.Assert.assertEquals((String)((User)users.get(1)).getLoginName(), (String)"john");
        junit.framework.Assert.assertEquals((String)((User)users.get(2)).getLoginName(), (String)"john2");
        junit.framework.Assert.assertEquals((String)((User)users.get(3)).getLoginName(), (String)"mary");
        junit.framework.Assert.assertEquals((String)((User)users.get(4)).getLoginName(), (String)"mary2");
        userQuery = this.getIdentityManager().createIdentityQuery(User.class);
        userQuery.setOffset(5);
        userQuery.setLimit(5);
        users = userQuery.getResultList();
        junit.framework.Assert.assertEquals((int)1, (int)users.size());
        junit.framework.Assert.assertEquals((String)((User)users.get(0)).getLoginName(), (String)"root");
        userQuery = this.getIdentityManager().createIdentityQuery(User.class);
        userQuery.setOffset(0);
        userQuery.setLimit(5);
        userQuery.setSortParameters(new QueryParameter[]{User.LAST_NAME, User.FIRST_NAME});
        users = userQuery.getResultList();
        junit.framework.Assert.assertEquals((int)5, (int)users.size());
        junit.framework.Assert.assertEquals((String)((User)users.get(0)).getLoginName(), (String)"john");
        junit.framework.Assert.assertEquals((String)((User)users.get(1)).getLoginName(), (String)"mary2");
        junit.framework.Assert.assertEquals((String)((User)users.get(2)).getLoginName(), (String)"demo");
        junit.framework.Assert.assertEquals((String)((User)users.get(3)).getLoginName(), (String)"john2");
        junit.framework.Assert.assertEquals((String)((User)users.get(4)).getLoginName(), (String)"mary");
        userQuery = this.getIdentityManager().createIdentityQuery(User.class);
        userQuery.setOffset(0);
        userQuery.setLimit(3);
        userQuery.setSortParameters(new QueryParameter[]{IdentityType.CREATED_DATE});
        users = userQuery.getResultList();
        junit.framework.Assert.assertEquals((int)3, (int)users.size());
        junit.framework.Assert.assertEquals((String)((User)users.get(0)).getLoginName(), (String)"john");
        junit.framework.Assert.assertEquals((String)((User)users.get(1)).getLoginName(), (String)"root");
        junit.framework.Assert.assertEquals((String)((User)users.get(2)).getLoginName(), (String)"mary");
    }

    private void createPopulatedUser(String username, String firstName, String lastName) {
        User user = this.createUser(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        this.getIdentityManager().update((IdentityType)user);
    }
}

