/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreWithoutAttributesTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;

public class GroupMembershipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testCreate() throws Exception {
        User someUser = this.createUser();
        Group someGroup = this.createGroup();
        GroupMembership groupMembership = new GroupMembership((Agent)someUser, someGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.add((Relationship)groupMembership);
        List<GroupMembership> result = this.getGroupMembership(someUser, someGroup);
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testUpdate() throws Exception {
        User someUser = this.createUser();
        Group someGroup = this.createGroup();
        GroupMembership groupMembership = new GroupMembership((Agent)someUser, someGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.add((Relationship)groupMembership);
        List<GroupMembership> result = this.getGroupMembership(someUser, someGroup);
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
        groupMembership.setAttribute(new Attribute("attribute1", (Serializable)((Object)"1")));
        groupMembership.setAttribute(new Attribute("attribute2", (Serializable)new String[]{"1", "2", "3"}));
        identityManager.update((Relationship)groupMembership);
        result = this.getGroupMembership(someUser, someGroup);
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
        Assert.assertNotNull((Object)groupMembership.getAttribute("attribute1"));
        Assert.assertNotNull((Object)groupMembership.getAttribute("attribute2"));
        Assert.assertEquals((Object)"1", (Object)groupMembership.getAttribute("attribute1").getValue());
        Assert.assertEquals((long)3L, (long)((String[])groupMembership.getAttribute("attribute2").getValue()).length);
    }

    @Test
    public void testAddUserToGroup() throws Exception {
        User someUser = this.createUser("someUser");
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((Agent)someUser, someGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
        identityManager.addToGroup((Agent)someUser, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
    }

    @Test
    public void testAddUserToParentGroup() throws Exception {
        User someUser = this.createUser("someUser");
        Group groupB = this.createGroup("b", "a");
        Group groupA = groupB.getParentGroup();
        Assert.assertNotNull((Object)groupA);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((Agent)someUser, groupA);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupA));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupB));
        identityManager.remove((IdentityType)groupB);
        identityManager.remove((IdentityType)groupA);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, groupB));
        groupA = this.createGroup("a", null);
        groupB = this.createGroupWithParent("b", groupA);
        Group groupC = this.createGroupWithParent("c", groupB);
        identityManager.addToGroup((Agent)someUser, groupA);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupA));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupB));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupC));
        identityManager.remove((IdentityType)groupC);
        identityManager.remove((IdentityType)groupB);
        identityManager.remove((IdentityType)groupA);
        groupA = this.createGroup("a", null);
        groupB = this.createGroupWithParent("b", groupA);
        groupC = this.createGroupWithParent("c", groupB);
        Group groupD = this.createGroupWithParent("d", groupC);
        Group qaGroup = this.createGroupWithParent("QA Group", groupC);
        Group anotherGroupB = this.createGroupWithParent("b", qaGroup);
        identityManager.addToGroup((Agent)someUser, anotherGroupB);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, anotherGroupB));
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, groupA));
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, groupB));
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, groupC));
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, groupD));
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, qaGroup));
        identityManager.addToGroup((Agent)someUser, groupB);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupB));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupD));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, qaGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, anotherGroupB));
        identityManager.removeFromGroup((Agent)someUser, anotherGroupB);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupB));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, groupD));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, qaGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, anotherGroupB));
    }

    @Test
    public void testRemoveUserWithRelationships() throws Exception {
        User someUser = this.createUser("someUser");
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((Agent)someUser, someGroup);
        identityManager.remove((IdentityType)someUser);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
    }

    @Test
    public void testRemoveUserFromGroup() throws Exception {
        User someUser = this.createUser("someUser");
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup((Agent)someUser, someGroup);
        identityManager.addToGroup((Agent)someUser, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
        identityManager.removeFromGroup((Agent)someUser, someGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someGroup));
        Assert.assertTrue((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
        identityManager.removeFromGroup((Agent)someUser, someAnotherGroup);
        Assert.assertFalse((boolean)identityManager.isMember((IdentityType)someUser, someAnotherGroup));
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindByAttributes() throws Exception {
        User someUser = this.createUser();
        Group someGroup = this.createGroup();
        GroupMembership groupMembership = new GroupMembership((Agent)someUser, someGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.add((Relationship)groupMembership);
        RelationshipQuery query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute1"), new Object[]{"1"});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        groupMembership.setAttribute(new Attribute("attribute1", (Serializable)((Object)"1")));
        groupMembership.setAttribute(new Attribute("attribute2", (Serializable)new String[]{"1", "2", "3"}));
        identityManager.update((Relationship)groupMembership);
        result = query.getResultList();
        Assert.assertEquals((long)1L, (long)result.size());
        groupMembership = (GroupMembership)result.get(0);
        Assert.assertEquals((Object)someUser.getId(), (Object)groupMembership.getMember().getId());
        Assert.assertEquals((Object)someGroup.getId(), (Object)groupMembership.getGroup().getId());
        query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute1"), new Object[]{"2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute3"), new Object[]{"2"});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"attribute2"), new Object[]{"1", "2", "3"});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testLargeAttributeValue() throws Exception {
        User someUser = this.createUser();
        Group someGroup = this.createGroup();
        GroupMembership groupMembership = new GroupMembership((Agent)someUser, someGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.add((Relationship)groupMembership);
        Integer[] val = new Integer[1000];
        for (int i = 0; i < 999; ++i) {
            val[i] = i;
        }
        groupMembership.setAttribute(new Attribute("Values", (Serializable)val));
        identityManager.update((Relationship)groupMembership);
        RelationshipQuery query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{someUser});
        query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{someGroup});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        GroupMembership updatedIdentityType = (GroupMembership)result.get(0);
        Integer[] retrievedVal = (Integer[])updatedIdentityType.getAttribute("Values").getValue();
        for (int i = 0; i < 999; ++i) {
            assert (retrievedVal[i] == i);
        }
    }

    @Test
    public void testFindUserGroups() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        Group someImportantGroup = this.createGroup("someImportantGroup", null);
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((Agent)user, someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((Agent)user, someAnotherGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup((Agent)user, someImportantGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantGroup"));
    }

    private Group createGroup() {
        return this.createGroup("someGroup", null);
    }

    private User createUser() {
        return this.createUser("someUser");
    }

    private List<GroupMembership> getGroupMembership(User someUser, Group someGroup) {
        IdentityManager identityManager = this.getIdentityManager();
        RelationshipQuery query = identityManager.createRelationshipQuery(GroupMembership.class);
        query.setParameter((QueryParameter)GroupMembership.MEMBER, new Object[]{someUser});
        query.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{someGroup});
        return query.getResultList();
    }

    private boolean contains(List<Group> result, String roleId) {
        for (Group resultGroup : result) {
            if (!resultGroup.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

