/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.suites;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.test.idm.IdentityManagerRunner;
import org.picketlink.test.idm.TestLifecycle;
import org.picketlink.test.idm.basic.AgentManagementTestCase;
import org.picketlink.test.idm.basic.GroupManagementTestCase;
import org.picketlink.test.idm.basic.RoleManagementTestCase;
import org.picketlink.test.idm.basic.UserManagementTestCase;
import org.picketlink.test.idm.credential.PasswordCredentialTestCase;
import org.picketlink.test.idm.query.AgentQueryTestCase;
import org.picketlink.test.idm.query.GroupQueryTestCase;
import org.picketlink.test.idm.query.RelationshipQueryTestCase;
import org.picketlink.test.idm.query.RoleQueryTestCase;
import org.picketlink.test.idm.query.UserQueryTestCase;
import org.picketlink.test.idm.relationship.AgentGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupsRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupMembershipTestCase;
import org.picketlink.test.idm.relationship.UserGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.UserGroupRoleRelationshipTestCase;

@RunWith(value=IdentityManagerRunner.class)
@Suite.SuiteClasses(value={RelationshipQueryTestCase.class, UserManagementTestCase.class, PasswordCredentialTestCase.class, RoleManagementTestCase.class, GroupManagementTestCase.class, AgentManagementTestCase.class, AgentQueryTestCase.class, UserQueryTestCase.class, RoleQueryTestCase.class, GroupQueryTestCase.class, AgentGroupRoleRelationshipTestCase.class, AgentGroupsRelationshipTestCase.class, UserGrantRelationshipTestCase.class, AgentGrantRelationshipTestCase.class, GroupGrantRelationshipTestCase.class, UserGroupRoleRelationshipTestCase.class, GroupMembershipTestCase.class})
public class LDAPIdentityStoreWithoutAttributesTestSuite
extends AbstractLDAPTest
implements TestLifecycle {
    private static final String BASE_DN = "dc=jboss,dc=org";
    private static final String LDAP_URL = "ldap://localhost:10389";
    private static final String ROLES_DN_SUFFIX = "ou=Roles,dc=jboss,dc=org";
    private static final String GROUP_DN_SUFFIX = "ou=Groups,dc=jboss,dc=org";
    private static final String USER_DN_SUFFIX = "ou=People,dc=jboss,dc=org";
    private static final String AGENT_DN_SUFFIX = "ou=Agent,dc=jboss,dc=org";
    private static LDAPIdentityStoreWithoutAttributesTestSuite instance;

    public static TestLifecycle init() throws Exception {
        if (instance == null) {
            instance = new LDAPIdentityStoreWithoutAttributesTestSuite();
        }
        return instance;
    }

    @BeforeClass
    public static void onBeforeClass() {
        try {
            LDAPIdentityStoreWithoutAttributesTestSuite.init();
            instance.setup();
            instance.importLDIF("ldap/users.ldif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void onDestroyClass() {
        try {
            instance.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public IdentityManagerFactory createIdentityManagerFactory() {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((LDAPStoreConfigurationBuilder)builder.stores().ldap().baseDN(BASE_DN).bindDN("uid=admin,ou=system").bindCredential("secret").url(LDAP_URL).userDNSuffix(USER_DN_SUFFIX).roleDNSuffix(ROLES_DN_SUFFIX).agentDNSuffix(AGENT_DN_SUFFIX).groupDNSuffix(GROUP_DN_SUFFIX).addGroupMapping("/QA Group", "ou=QA,dc=jboss,dc=org").supportAllFeatures()).removeFeature(FeatureSet.FeatureGroup.attribute);
        return new IdentityManagerFactory(builder.build());
    }

    public void importLDIF(String fileName) throws Exception {
        super.importLDIF(fileName);
    }
}

