/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.AbstractIdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.BaseAbstractStoreConfiguration;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.SecurityContext;

public class CustomIdentityStoreTestCase {
    @Test
    public void testConfiguration() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        MethodInvocationContext methodInvocationContext = new MethodInvocationContext();
        ((MyIdentityStoreConfigurationBuilder)((MyIdentityStoreConfigurationBuilder)((MyIdentityStoreConfigurationBuilder)builder.stores().add(MyIdentityStoreConfiguration.class, MyIdentityStore.class, MyIdentityStoreConfigurationBuilder.class)).methodInvocationContext(methodInvocationContext).addRealm(new String[]{"default"})).addTier(new String[]{"SomeTier"})).supportAllFeatures();
        IdentityConfiguration configuration = builder.build();
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(configuration);
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        identityManager.add((IdentityType)new SimpleUser("john"));
        Assert.assertEquals((String)"addAttributedType", (String)methodInvocationContext.getMethodName());
        identityManager.getUser("john");
        Assert.assertEquals((String)"getUser", (String)methodInvocationContext.getMethodName());
    }

    public static class MethodInvocationContext {
        private String methodName;

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    public static class MyIdentityStore
    implements CredentialStore<MyIdentityStoreConfiguration> {
        private MyIdentityStoreConfiguration config;

        public void setup(MyIdentityStoreConfiguration config) {
            this.config = config;
        }

        public MyIdentityStoreConfiguration getConfig() {
            return this.config;
        }

        public void add(SecurityContext context, AttributedType value) {
            value.setId(context.getIdGenerator().generate());
            this.getConfig().getMethodInvocationContext().setMethodName("addAttributedType");
        }

        public void update(SecurityContext context, AttributedType value) {
        }

        public void remove(SecurityContext context, AttributedType value) {
        }

        public Agent getAgent(SecurityContext context, String loginName) {
            return null;
        }

        public User getUser(SecurityContext context, String loginName) {
            this.getConfig().getMethodInvocationContext().setMethodName("getUser");
            return null;
        }

        public Group getGroup(SecurityContext context, String groupPath) {
            return null;
        }

        public Group getGroup(SecurityContext context, String name, Group parent) {
            return null;
        }

        public Role getRole(SecurityContext context, String name) {
            return null;
        }

        public <V extends IdentityType> List<V> fetchQueryResults(SecurityContext context, IdentityQuery<V> identityQuery) {
            return null;
        }

        public <V extends IdentityType> int countQueryResults(SecurityContext context, IdentityQuery<V> identityQuery) {
            return 0;
        }

        public <V extends Relationship> List<V> fetchQueryResults(SecurityContext context, RelationshipQuery<V> query) {
            return null;
        }

        public <V extends Relationship> int countQueryResults(SecurityContext context, RelationshipQuery<V> query) {
            return 0;
        }

        public void setAttribute(SecurityContext context, IdentityType identityType, Attribute<? extends Serializable> attribute) {
        }

        public <V extends Serializable> Attribute<V> getAttribute(SecurityContext context, IdentityType identityType, String attributeName) {
            return null;
        }

        public void removeAttribute(SecurityContext context, IdentityType identityType, String attributeName) {
        }

        public void validateCredentials(SecurityContext context, Credentials credentials) {
        }

        public void updateCredential(SecurityContext context, Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        }

        public void storeCredential(SecurityContext context, Agent agent, CredentialStorage storage) {
        }

        public <T extends CredentialStorage> T retrieveCurrentCredential(SecurityContext context, Agent agent, Class<T> storageClass) {
            return null;
        }

        public <T extends CredentialStorage> List<T> retrieveCredentials(SecurityContext context, Agent agent, Class<T> storageClass) {
            return null;
        }
    }

    public static class MyIdentityStoreConfiguration
    extends BaseAbstractStoreConfiguration {
        private MethodInvocationContext methodInvocationContext;

        public MyIdentityStoreConfiguration(Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> supportedFeatures, Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> supportedRelationships, Set<String> realms, Set<String> tiers, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, List<Class<? extends CredentialHandler>> credentialHandlers) {
            super(supportedFeatures, supportedRelationships, realms, tiers, contextInitializers, credentialHandlerProperties, credentialHandlers);
        }

        protected void initConfig() {
        }

        public void setMethodInvocationContext(MethodInvocationContext assertion) {
            this.methodInvocationContext = assertion;
        }

        public MethodInvocationContext getMethodInvocationContext() {
            return this.methodInvocationContext;
        }
    }

    public static class MyIdentityStoreConfigurationBuilder
    extends AbstractIdentityStoreConfigurationBuilder<MyIdentityStoreConfiguration, MyIdentityStoreConfigurationBuilder> {
        private MethodInvocationContext methodInvocationContext;

        public MyIdentityStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
            super(builder);
        }

        public MyIdentityStoreConfiguration create() {
            MyIdentityStoreConfiguration config = new MyIdentityStoreConfiguration(this.getSupportedFeatures(), this.getSupportedRelationships(), this.getRealms(), this.getTiers(), this.getContextInitializers(), this.getCredentialHandlerProperties(), this.getCredentialHandlers());
            config.setMethodInvocationContext(this.methodInvocationContext);
            return config;
        }

        public MyIdentityStoreConfigurationBuilder methodInvocationContext(MethodInvocationContext methodInvocationContext) {
            this.methodInvocationContext = methodInvocationContext;
            return this;
        }
    }
}

